/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.datagen;

import appeng.api.orientation.BlockOrientation;
import appeng.block.crafting.PatternProviderBlock;
import appeng.core.AppEng;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.datagen.providers.models.AE2BlockStateProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.blocks.AAEAbstractCraftingUnitBlock;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;
import net.pedroksl.advanced_ae.common.blocks.QuantumCrafterBlock;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.FluidDefinition;

public class AAEModelProvider
extends AE2BlockStateProvider {
    public AAEModelProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "advanced_ae", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.basicItem(AAEItems.ADV_PROCESSING_PATTERN);
        this.basicItem(AAEItems.ADV_PATTERN_PROVIDER_UPGRADE);
        this.basicItem(AAEItems.ADV_PATTERN_PROVIDER_CAPACITY_UPGRADE);
        this.basicItem(AAEItems.ADV_PATTERN_ENCODER);
        this.basicItem(AAEItems.SHATTERED_SINGULARITY);
        this.basicItem(AAEItems.QUANTUM_INFUSED_DUST);
        this.basicItem(AAEItems.QUANTUM_ALLOY);
        this.basicItem(AAEItems.QUANTUM_ALLOY_PLATE);
        this.basicItem(AAEItems.QUANTUM_PROCESSOR_PRESS);
        this.basicItem(AAEItems.QUANTUM_PROCESSOR_PRINT);
        this.basicItem(AAEItems.QUANTUM_PROCESSOR);
        this.basicItem(AAEItems.QUANTUM_STORAGE_COMPONENT);
        this.basicItem(AAEItems.MONITOR_CONFIGURATOR);
        this.basicItem(AAEItems.QUANTUM_HELMET);
        this.basicItem(AAEItems.QUANTUM_CHESTPLATE);
        this.basicItem(AAEItems.QUANTUM_LEGGINGS);
        this.basicItem(AAEItems.QUANTUM_BOOTS);
        this.stairsBlock(AAEBlocks.QUANTUM_ALLOY_STAIRS, AAEBlocks.QUANTUM_ALLOY_BLOCK);
        this.slabBlock(AAEBlocks.QUANTUM_ALLOY_SLAB, AAEBlocks.QUANTUM_ALLOY_BLOCK);
        this.wall(AAEBlocks.QUANTUM_ALLOY_WALL, "block/quantum_alloy_block");
        for (ItemDefinition<?> card : AAEItems.getQuantumCards()) {
            this.basicItem(card, "upgrades");
        }
        this.quantumCrafterModel();
        for (AAECraftingUnitType type : AAECraftingUnitType.values()) {
            if (type == AAECraftingUnitType.QUANTUM_CORE || type == AAECraftingUnitType.STRUCTURE) continue;
            this.basicCraftingBlockModel(type);
        }
        AAECraftingUnitType type = AAECraftingUnitType.STRUCTURE;
        Block craftingBlock = type.getDefinition().block();
        String name = type.getAffix();
        BlockModelBuilder blockModel = (BlockModelBuilder)this.models().cubeAll("block/crafting/" + name, AdvancedAE.makeId("block/crafting/" + name));
        this.getVariantBuilder(craftingBlock).partialState().with((Property)AAEAbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)blockModel)}).partialState().with((Property)AAEAbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getBuilder("block/crafting/" + name + "_formed"))});
        this.simpleBlockItem(craftingBlock, (ModelFile)blockModel);
        this.interfaceOrProviderPart(AAEItems.ADV_PATTERN_PROVIDER);
        this.interfaceOrProviderPart(AAEItems.SMALL_ADV_PATTERN_PROVIDER);
        this.interfaceOrProviderPart(AAEItems.STOCK_EXPORT_BUS, true);
        this.interfaceOrProviderPart(AAEItems.IMPORT_EXPORT_BUS, true);
        this.patternProvider(AAEBlocks.ADV_PATTERN_PROVIDER);
        this.patternProvider(AAEBlocks.SMALL_ADV_PATTERN_PROVIDER);
        this.fluidBlocks();
        this.buckets();
    }

    private void basicItem(ItemDefinition<?> item) {
        this.basicItem(item, "");
    }

    private void basicItem(ItemDefinition<?> item, String texturePath) {
        if (texturePath.isEmpty()) {
            this.itemModels().basicItem(item.asItem());
        } else {
            String id = item.id().getPath();
            this.itemModels().singleTexture(id, this.mcLoc("item/generated"), "layer0", AdvancedAE.makeId("item/" + texturePath + "/" + id));
        }
    }

    private void basicBlock(BlockDefinition<?> block) {
        ModelFile model = this.cubeAll(block.block());
        this.simpleBlock(block.block(), model);
        this.simpleBlockItem(block.block(), model);
    }

    private void basicCraftingBlockModel(AAECraftingUnitType type) {
        Block craftingBlock = type.getDefinition().block();
        BlockModelBuilder blockModel = (BlockModelBuilder)this.models().cubeAll("block/crafting/" + type.getAffix(), AdvancedAE.makeId("block/crafting/" + type.getAffix()));
        this.simpleBlockItem(craftingBlock, (ModelFile)blockModel);
        this.simpleBlock(craftingBlock, (ModelFile)blockModel);
    }

    private void interfaceOrProviderPart(ItemDefinition<?> part) {
        this.interfaceOrProviderPart(part, false);
    }

    private void interfaceOrProviderPart(ItemDefinition<?> part, boolean isExport) {
        String id = part.id().getPath();
        String partName = id.substring(0, id.lastIndexOf(95));
        ResourceLocation front = AdvancedAE.makeId("part/" + partName);
        ResourceLocation back = AdvancedAE.makeId("part/" + partName + "_back");
        ResourceLocation sides = AdvancedAE.makeId("part/" + partName + "_sides");
        ResourceLocation base = isExport ? AppEng.makeId((String)"part/export_bus_base") : AppEng.makeId((String)"part/pattern_provider_base");
        ResourceLocation itemBase = isExport ? AppEng.makeId((String)"item/export_bus") : AppEng.makeId((String)"item/cable_pattern_provider");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("part/" + id, base, "sidesStatus", AppEng.makeId((String)"part/monitor_sides_status"))).texture("sides", sides)).texture("front", front)).texture("back", back)).texture("particle", back);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().singleTexture("item/" + id, itemBase, "sides", sides)).texture("front", front)).texture("back", back);
    }

    private void patternProvider(BlockDefinition<?> block) {
        ModelFile patternProviderNormal = this.cubeAll(block.block());
        this.simpleBlockItem(block.block(), patternProviderNormal);
        String blockName = block.id().getPath();
        BlockModelBuilder patternProviderOriented = (BlockModelBuilder)this.models().cubeBottomTop("block/" + blockName + "_oriented", AdvancedAE.makeId("block/" + blockName + "_alt"), AdvancedAE.makeId("block/" + blockName + "_back"), AdvancedAE.makeId("block/" + blockName + "_front"));
        this.multiVariantGenerator(block, new Variant[]{Variant.variant()}).with(PropertyDispatch.property((Property)PatternProviderBlock.PUSH_DIRECTION).generate(dir -> {
            Direction forward = dir.getDirection();
            if (forward == null) {
                return Variant.variant().with(VariantProperties.MODEL, (Object)patternProviderNormal.getLocation());
            }
            BlockOrientation orientation = BlockOrientation.get((Direction)forward);
            return AAEModelProvider.applyRotation((Variant)Variant.variant().with(VariantProperties.MODEL, (Object)patternProviderOriented.getLocation()), (int)(orientation.getAngleX() + 90), (int)orientation.getAngleY(), (int)0);
        }));
    }

    private void quantumCrafterModel() {
        ResourceLocation grid = AdvancedAE.makeId("block/quantum_crafter_grid");
        ResourceLocation gridOn = AdvancedAE.makeId("block/quantum_crafter_grid_on");
        ResourceLocation bottom = AdvancedAE.makeId("block/quantum_crafter_bottom");
        ResourceLocation sides = AdvancedAE.makeId("block/quantum_crafter_side");
        QuantumCrafterBlock block = (QuantumCrafterBlock)AAEBlocks.QUANTUM_CRAFTER.block();
        BlockModelBuilder blockModel = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeBottomTop("quantum_crafter", sides, bottom, grid)).texture("north", grid);
        BlockModelBuilder blockModelOn = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeBottomTop("quantum_crafter_on", sides, bottom, gridOn)).texture("north", gridOn);
        this.multiVariantGenerator(AAEBlocks.QUANTUM_CRAFTER, new Variant[]{Variant.variant()}).with(PropertyDispatch.property((Property)QuantumCrafterBlock.WORKING).generate(working -> {
            BlockModelBuilder model = working != false ? blockModelOn : blockModel;
            return Variant.variant().with(VariantProperties.MODEL, (Object)model.getLocation());
        })).with(AAEModelProvider.createFacingSpinDispatch());
        this.simpleBlockItem((Block)block, (ModelFile)blockModelOn);
    }

    protected void stairsBlock(BlockDefinition<StairBlock> stairs, String bottomTexture, String sideTexture, String topTexture) {
        String baseName = stairs.id().getPath();
        ResourceLocation side = AdvancedAE.makeId(sideTexture);
        ResourceLocation bottom = AdvancedAE.makeId(bottomTexture);
        ResourceLocation top = AdvancedAE.makeId(topTexture);
        ModelBuilder stairsModel = this.models().stairs(baseName, side, bottom, top);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.stairsBlock((StairBlock)stairs.block(), (ModelFile)stairsModel, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.simpleBlockItem(stairs.block(), (ModelFile)stairsModel);
    }

    protected void slabBlock(BlockDefinition<SlabBlock> slab, BlockDefinition<?> base, String bottomTexture, String sideTexture, String topTexture) {
        ResourceLocation side = AdvancedAE.makeId(sideTexture);
        ResourceLocation bottom = AdvancedAE.makeId(bottomTexture);
        ResourceLocation top = AdvancedAE.makeId(topTexture);
        BlockModelBuilder bottomModel = (BlockModelBuilder)this.models().slab(slab.id().getPath(), side, bottom, top);
        this.simpleBlockItem(slab.block(), (ModelFile)bottomModel);
        this.slabBlock((SlabBlock)slab.block(), (ModelFile)bottomModel, (ModelFile)this.models().slabTop(slab.id().getPath() + "_top", side, bottom, top), (ModelFile)this.models().getExistingFile(base.id()));
    }

    protected void wall(BlockDefinition<WallBlock> block, String texture) {
        this.wallBlock((WallBlock)block.block(), AdvancedAE.makeId(texture));
        this.itemModels().wallInventory(block.id().getPath(), AdvancedAE.makeId(texture));
    }

    private void fluidBlocks() {
        for (FluidDefinition<?, ?> fluids : AAEFluids.getFluids()) {
            this.simpleBlock((Block)fluids.block(), (ModelFile)((BlockModelBuilder)this.models().getBuilder(fluids.blockId().getId().getPath())).texture("particle", AdvancedAE.makeId("block/water_still")));
        }
    }

    public void buckets() {
        for (FluidDefinition<?, ?> fluids : AAEFluids.getFluids()) {
            ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(fluids.bucketItemId().id().getPath(), ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item/bucket"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(fluids.bucketItem().content);
        }
    }

    public String getName() {
        return "Block States / Models";
    }
}

