/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.datagen;

import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import java.util.Iterator;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeys;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMaterials;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.definitions.FluidDefinition;
import net.pedroksl.advanced_ae.common.definitions.MaterialDefinition;
import org.jetbrains.annotations.NotNull;

public class AAELanguageProvider
extends LanguageProvider {
    public AAELanguageProvider(PackOutput output) {
        super(output, "advanced_ae", "en_us");
    }

    protected void addTranslations() {
        for (ItemDefinition<?> itemDefinition : AAEItems.getItems()) {
            this.add(itemDefinition.asItem(), itemDefinition.getEnglishName());
        }
        for (BlockDefinition blockDefinition : AAEBlocks.getBlocks()) {
            this.add(blockDefinition.block(), blockDefinition.getEnglishName());
        }
        for (FluidDefinition fluidDefinition : AAEFluids.getFluids()) {
            this.add(fluidDefinition.fluidType(), fluidDefinition.getEnglishName());
            this.add((Fluid)fluidDefinition.flowing(), fluidDefinition.getEnglishName());
            this.add((Fluid)fluidDefinition.source(), fluidDefinition.getEnglishName());
            this.add((Block)fluidDefinition.block(), fluidDefinition.getEnglishName());
            this.add((Item)fluidDefinition.bucketItem(), fluidDefinition.bucketItemId().getEnglishName());
        }
        for (Iterator<Object> iterator : AAEText.values()) {
            this.add(((AAEText)((Object)iterator)).getTranslationKey(), ((AAEText)((Object)iterator)).getEnglishText());
        }
        for (MaterialDefinition materialDefinition : AAEMaterials.getMaterials()) {
            this.add((ArmorMaterial)materialDefinition.get(), materialDefinition.getEnglishName());
        }
        for (Iterator<Object> iterator : AAEHotkeys.Keys.values()) {
            this.add("key.advanced_ae." + ((AAEHotkeys.Keys)((Object)iterator)).getId(), ((AAEHotkeys.Keys)((Object)iterator)).getEnglishTranslation());
        }
        this.generateLocalizations();
    }

    private void generateLocalizations() {
        this.add("key.advanced_ae.category", "Advanced AE");
        this.add("curios.identifier.adv_pattern_encoder", "Pattern Encoder");
    }

    public void add(FluidType key, String englishName) {
        this.add(Util.makeDescriptionId((String)"fluid_type", (ResourceLocation)NeoForgeRegistries.FLUID_TYPES.getKey((Object)key)), englishName);
    }

    public void add(Fluid key, String englishName) {
        this.add(Util.makeDescriptionId((String)"fluid", (ResourceLocation)BuiltInRegistries.FLUID.getKey((Object)key)), englishName);
    }

    public void add(ArmorMaterial key, String englishName) {
        this.add(Util.makeDescriptionId((String)"material", (ResourceLocation)BuiltInRegistries.ARMOR_MATERIAL.getKey((Object)key)), englishName);
    }

    @NotNull
    public String getName() {
        return "Language";
    }
}

