/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.fluids;

import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;

public abstract class QuantumInfusionFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(AAEFluids.QUANTUM_INFUSION.fluidTypeId(), AAEFluids.QUANTUM_INFUSION.flowingId(), AAEFluids.QUANTUM_INFUSION.sourceId()).bucket(AAEFluids.QUANTUM_INFUSION.bucketItemId()).block(AAEFluids.QUANTUM_INFUSION.blockId());

    protected QuantumInfusionFluid(BaseFlowingFluid.Properties properties) {
        super(properties);
    }

    public Fluid getFlowing() {
        return AAEFluids.QUANTUM_INFUSION.flowing();
    }

    public Fluid getSource() {
        return AAEFluids.QUANTUM_INFUSION.source();
    }

    public Item getBucket() {
        return AAEFluids.QUANTUM_INFUSION.bucketItem();
    }

    protected boolean canConvertToSource(Level pLevel) {
        return false;
    }

    public static class Source
    extends QuantumInfusionFluid {
        public Source() {
            super(PROPERTIES);
        }

        public int getAmount(FluidState pState) {
            return 8;
        }

        public boolean isSource(FluidState pState) {
            return true;
        }
    }

    public static class Flowing
    extends QuantumInfusionFluid {
        public Flowing() {
            super(PROPERTIES);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> pBuilder) {
            super.createFluidStateDefinition(pBuilder);
            pBuilder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState pState) {
            return (Integer)pState.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState pState) {
            return false;
        }
    }
}

