/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.api.stacks.GenericStack;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.common.patterns.EncodedAdvProcessingPattern;

public final class AAEComponents {
    public static final DeferredRegister<DataComponentType<?>> DR = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"advanced_ae");
    public static final DataComponentType<EncodedAdvProcessingPattern> ENCODED_ADV_PROCESSING_PATTERN = AAEComponents.register("encoded_adv_processing_pattern", builder -> builder.persistent(EncodedAdvProcessingPattern.CODEC).networkSynchronized(EncodedAdvProcessingPattern.STREAM_CODEC));
    public static final DataComponentType<CompoundTag> STACK_TAG = AAEComponents.register("generic_nbt", builder -> builder.persistent(CompoundTag.CODEC).networkSynchronized(ByteBufCodecs.COMPOUND_TAG));
    public static final DataComponentType<CompoundTag> PORTABLE_CELL_STACK_TAG = AAEComponents.register("portable_cell_stack", builder -> builder.persistent(CompoundTag.CODEC).networkSynchronized(ByteBufCodecs.COMPOUND_TAG));
    public static final DataComponentType<Boolean> NIGHT_VISION_ACTIVATED = AAEComponents.register("night_vision_activated", builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final DataComponentType<List<Integer>> EXPORTED_ALLOWED_SIDES = AAEComponents.register("allowed_output_sides", builder -> builder.persistent(Codec.list((Codec)Codec.of((Encoder)Codec.INT, (Decoder)Codec.INT))).networkSynchronized(ByteBufCodecs.INT.apply(ByteBufCodecs.list())));
    public static final Map<UpgradeType, DataComponentType<Boolean>> UPGRADE_TOGGLE = new HashMap<UpgradeType, DataComponentType<Boolean>>();
    public static final Map<UpgradeType, DataComponentType<Integer>> UPGRADE_VALUE = new HashMap<UpgradeType, DataComponentType<Integer>>();
    public static final Map<UpgradeType, DataComponentType<List<GenericStack>>> UPGRADE_FILTER = new HashMap<UpgradeType, DataComponentType<List<GenericStack>>>();
    public static final Map<UpgradeType, DataComponentType<Boolean>> UPGRADE_EXTRA = new HashMap<UpgradeType, DataComponentType<Boolean>>();

    public static void init() {
        for (UpgradeType upgrade : UpgradeType.values()) {
            DataComponentType toggle = AAEComponents.register(upgrade.name().toLowerCase(Locale.ROOT) + "_toggle", builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
            DataComponentType value = AAEComponents.register(upgrade.name().toLowerCase(Locale.ROOT) + "_value", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));
            DataComponentType filter = AAEComponents.register(upgrade.name().toLowerCase(Locale.ROOT) + "_filter", builder -> builder.persistent(Codec.list((Codec)GenericStack.CODEC)).networkSynchronized(GenericStack.STREAM_CODEC.apply(ByteBufCodecs.list())));
            UPGRADE_TOGGLE.put(upgrade, toggle);
            UPGRADE_VALUE.put(upgrade, value);
            UPGRADE_FILTER.put(upgrade, filter);
            if (upgrade.getExtraSettings() == UpgradeType.ExtraSettings.NONE) continue;
            DataComponentType extra = AAEComponents.register(upgrade.name().toLowerCase(Locale.ROOT) + "_extra", builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
            UPGRADE_EXTRA.put(upgrade, extra);
        }
    }

    private static <T> DataComponentType<T> register(String name, Consumer<DataComponentType.Builder<T>> customizer) {
        DataComponentType.Builder builder = DataComponentType.builder();
        customizer.accept(builder);
        DataComponentType componentType = builder.build();
        DR.register(name, () -> componentType);
        return componentType;
    }
}

