/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.cluster;

import appeng.api.config.CpuSelectionMode;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.GenericStack;
import appeng.crafting.inv.ListCraftingInventory;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPUCluster;
import net.pedroksl.advanced_ae.common.logic.AdvCraftingCPULogic;
import net.pedroksl.advanced_ae.common.logic.ElapsedTimeTracker;
import org.jetbrains.annotations.Nullable;

public class AdvCraftingCPU
implements ICraftingCPU {
    final ICraftingPlan plan;
    private long fakeStorage = 0L;
    private final AdvCraftingCPUCluster cluster;
    public final AdvCraftingCPULogic craftingLogic = new AdvCraftingCPULogic(this);
    public GenericStack finalOutput;

    public AdvCraftingCPU(AdvCraftingCPUCluster cluster, ICraftingPlan plan) {
        this.cluster = cluster;
        this.plan = plan;
    }

    protected AdvCraftingCPU(AdvCraftingCPUCluster cluster, long fakeStorage) {
        this.cluster = cluster;
        this.plan = null;
        this.fakeStorage = fakeStorage;
    }

    public boolean isBusy() {
        return this.craftingLogic.hasJob();
    }

    @Nullable
    public CraftingJobStatus getJobStatus() {
        GenericStack finalOutput = this.craftingLogic.getFinalJobOutput();
        if (finalOutput != null) {
            ElapsedTimeTracker elapsedTimeTracker = this.craftingLogic.getElapsedTimeTracker();
            long progress = Math.max(0L, elapsedTimeTracker.getStartItemCount() - elapsedTimeTracker.getRemainingItemCount());
            return new CraftingJobStatus(finalOutput, elapsedTimeTracker.getStartItemCount(), progress, elapsedTimeTracker.getElapsedTime());
        }
        return null;
    }

    public void cancelJob() {
        if (this.plan == null) {
            return;
        }
        this.craftingLogic.cancel();
        this.cluster.cancelJob(this.plan);
    }

    public long getAvailableStorage() {
        return this.plan != null ? this.plan.bytes() : this.fakeStorage;
    }

    public int getCoProcessors() {
        return this.cluster.getCoProcessors();
    }

    @Nullable
    public Component getName() {
        return this.cluster.getName();
    }

    public CpuSelectionMode getSelectionMode() {
        return this.cluster.getSelectionMode();
    }

    public void markDirty() {
        this.cluster.markDirty();
    }

    public boolean isActive() {
        return this.cluster.isActive();
    }

    public Level getLevel() {
        return this.cluster.getLevel();
    }

    public IGrid getGrid() {
        return this.cluster.getGrid();
    }

    public void updateOutput(GenericStack stack) {
        this.finalOutput = stack;
    }

    public ListCraftingInventory getInventory() {
        return this.craftingLogic.getInventory();
    }

    public void deactivate() {
        this.cluster.deactivate(this.plan);
    }

    public IActionSource getSrc() {
        return this.cluster.getSrc();
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        this.craftingLogic.writeToNBT(data, registries);
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        this.craftingLogic.readFromNBT(data, registries);
    }
}

