/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.api.MarketPreset;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.blay09.mods.farmingforblockheads.registry.MarketPresetImpl;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;

public class MarketPresetRegistry {
    private static final Codec<MarketPreset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PaymentImpl.CODEC.fieldOf("payment").forGetter(MarketPreset::payment), (App)Codec.BOOL.fieldOf("enabled").orElse((Object)true).forGetter(MarketPreset::enabledByDefault)).apply((Applicative)instance, MarketPresetImpl::new));
    public static final MarketPresetRegistry INSTANCE = new MarketPresetRegistry();
    private final Map<ResourceLocation, MarketPreset> presets = new HashMap<ResourceLocation, MarketPreset>();

    public void register(ResourceLocation id, MarketPreset preset) {
        this.presets.put(id, preset);
    }

    public Collection<MarketPreset> getAll() {
        return MarketPresetRegistry.INSTANCE.presets.values();
    }

    public Optional<MarketPreset> get(ResourceLocation id) {
        return Optional.ofNullable(MarketPresetRegistry.INSTANCE.presets.get(id));
    }

    public void clear() {
        this.presets.clear();
    }

    public void loadAdditionally(ResourceLocation id, BufferedReader reader) {
        Gson gson = new Gson();
        JsonElement json = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
        MarketPreset category = (MarketPreset)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
        this.register(id, category);
    }

    public static boolean isRecipeEnabled(MarketRecipe recipe) {
        Set<ResourceLocation> disabledDefaultPresets = FarmingForBlockheadsConfig.getActive().disabledDefaultPresets;
        if (disabledDefaultPresets.contains(recipe.getPreset())) {
            return false;
        }
        Set<ResourceLocation> enabledOptionalPresets = FarmingForBlockheadsConfig.getActive().enabledOptionalPresets;
        Optional<MarketPreset> preset = INSTANCE.get(recipe.getPreset());
        if (preset.map(it -> !it.enabledByDefault() && !enabledOptionalPresets.contains(recipe.getPreset())).orElse(false).booleanValue()) {
            return false;
        }
        return !recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).isEmpty();
    }
}

