/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/world/level/block/SkullBlock", "net/minecraft/world/level/block/WallSkullBlock"})
public abstract class SkullBlockMixin
extends AbstractSkullBlock
implements SimpleWaterloggedBlock {
    public SkullBlockMixin(SkullBlock.Type type, BlockBehaviour.Properties properties) {
        super(type, properties);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            return false;
        }
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            if (!level.isClientSide()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            }
            return true;
        }
        return false;
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        if (!state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            return ItemStack.EMPTY;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            if (!state.canSurvive((LevelReader)level, pos)) {
                level.destroyBlock(pos, true);
            }
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/block/SkullBlock$Type;Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V"}, at={@At(value="RETURN")})
    private void amendments$dangerousAddWaterlogging(SkullBlock.Type type, BlockBehaviour.Properties properties, CallbackInfo ci) {
        if (this.defaultBlockState().hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE));
        }
    }

    public FluidState getFluidState(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)stateIn.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return stateIn;
    }

    @ModifyReturnValue(method={"getStateForPlacement(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="RETURN")})
    public BlockState amendments$addPlacementWaterlogging(BlockState original, BlockPlaceContext context) {
        if (original == null || !original.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            return original;
        }
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)original.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is(FluidTags.WATER) && fluidstate.getAmount() == 8));
    }

    @Inject(method={"createBlockStateDefinition(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V"}, at={@At(value="RETURN")})
    protected void amendments$addWaterlogging(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        if (!builder.properties.containsValue(BlockStateProperties.WATERLOGGED)) {
            builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        }
    }
}

