/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.mixins;

import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LavaCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={LavaCauldronBlock.class})
public abstract class LavaCauldronMixin
extends Block {
    public LavaCauldronMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        BlockPos blockPos;
        super.animateTick(state, level, pos, rand);
        if (rand.nextInt(4) == 0 && level.getBlockState(blockPos = pos.above()).isAir() && !level.getBlockState(blockPos).isSolidRender((BlockGetter)level, blockPos)) {
            Vec3 c = pos.getCenter();
            if (rand.nextInt(20) == 0) {
                ModCauldronBlock.addSurfaceParticles((ParticleOptions)ParticleTypes.LAVA, level, pos, 1, 0.9375, rand, 0.0f, 0.0f, 0.0f);
                level.playLocalSound(c.x, 0.9375, c.z, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(40) == 0) {
                level.playLocalSound(c.x, 0.9375, c.z, SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
    }
}

