/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipeInput;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class BoilingWaterCauldronBlock
extends LayeredCauldronBlock {
    public static final MapCodec<BoilingWaterCauldronBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Biome.Precipitation.CODEC.fieldOf("precipitation").forGetter(c -> c.precipitationType), (App)CauldronInteraction.CODEC.fieldOf("interactions").forGetter(c -> c.interactions), (App)BoilingWaterCauldronBlock.propertiesCodec()).apply((Applicative)i, BoilingWaterCauldronBlock::new));
    public static final BooleanProperty BOILING = ModBlockProperties.BOILING;
    private final Biome.Precipitation precipitationType;

    public BoilingWaterCauldronBlock(Biome.Precipitation precipitationType, CauldronInteraction.InteractionMap interactions, BlockBehaviour.Properties properties) {
        super(precipitationType, interactions, properties);
        this.precipitationType = precipitationType;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BOILING, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BOILING});
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (!level.isClientSide && this.isEntityInsideContent(state, pos, entity)) {
            if (((Boolean)state.getValue((Property)BOILING)).booleanValue() && entity instanceof LivingEntity) {
                entity.hurt(new DamageSource(ModRegistry.BOILING_DAMAGE), 1.0f);
            }
            if (entity.isOnFire()) {
                LiquidCauldronBlock.playExtinguishSound(level, pos, entity);
            }
            this.attemptStewCrafting(state, level, pos, entity);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockState s = super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
        if (direction == Direction.DOWN) {
            boolean isFire = LiquidCauldronBlock.shouldBoil(neighborState, SoftFluidStack.of((Holder)BuiltInSoftFluids.WATER), level, neighborPos);
            s = (BlockState)s.setValue((Property)BOILING, (Comparable)Boolean.valueOf(isFire));
        }
        return s;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (this.isEntityInsideContent(state, pos, entity)) {
            if (!level.isClientSide) {
                ModCauldronBlock.playSplashEffects(entity, this.getContentHeight(state));
            }
            super.fallOn(level, state, pos, entity, 0.0f);
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public static int getWaterColor(BlockState state, BlockAndTintGetter level, BlockPos pos, int i) {
        return i == 1 && level != null && pos != null ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos) : -1;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (((Boolean)state.getValue((Property)BOILING)).booleanValue()) {
            LiquidCauldronBlock.playBubblingAnimation(level, pos, this.getContentHeight(state), random, BoilingWaterCauldronBlock.getWaterColor(state, (BlockAndTintGetter)level, pos, 1), 0);
        }
    }

    private void attemptStewCrafting(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!((Boolean)state.getValue((Property)BOILING)).booleanValue() || !(entity instanceof ItemEntity) || entity.tickCount % 10 != 0) {
            return;
        }
        List entities = level.getEntitiesOfClass(ItemEntity.class, new AABB((double)pos.getX() + 0.125, (double)((float)pos.getY() + 0.375f), (double)pos.getZ() + 0.125, (double)pos.getX() + 0.875, (double)pos.getY() + this.getContentHeight(state), (double)pos.getZ() + 0.875));
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (ItemEntity e : entities) {
            ItemStack i = e.getItem();
            for (int c = 0; c < i.getCount(); ++c) {
                ingredients.add(i.copyWithCount(1));
            }
        }
        ingredients.add(Items.BOWL.getDefaultInstance());
        CraftingInput container = CauldronRecipeInput.of(ingredients);
        List recipes = level.getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)container, level);
        for (RecipeHolder r : recipes) {
            BlockState newState;
            Pair fluid;
            ItemStack result = ((CraftingRecipe)r.value()).assemble((RecipeInput)container, (HolderLookup.Provider)level.registryAccess());
            if (result.isEmpty() || (fluid = SoftFluidStack.fromItem((ItemStack)result)) == null || (newState = CauldronConversion.getNewState(pos, level, (SoftFluidStack)fluid.getFirst())) == null) continue;
            level.setBlockAndUpdate(pos, newState);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof LiquidCauldronBlockTile) {
                LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                int lev = (Integer)state.getValue((Property)LEVEL);
                int newLev = lev == 3 ? te.getSoftFluidTank().getCapacity() : lev;
                te.getSoftFluidTank().setFluid(((SoftFluidStack)fluid.getFirst()).copyWithCount(newLev));
                te.setChanged();
                level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
                level.playSound(null, pos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 0.9f, 0.6f);
            }
            BoilingWaterCauldronBlock.clearUsedIngredients(entities, ingredients);
        }
    }

    private static void clearUsedIngredients(List<ItemEntity> entities, List<ItemStack> ingredients) {
        for (ItemStack v : ingredients) {
            Iterator<ItemEntity> iter = entities.iterator();
            while (iter.hasNext()) {
                ItemEntity e = iter.next();
                ItemStack itemEntityItem = e.getItem();
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemEntityItem, (ItemStack)v)) continue;
                itemEntityItem.shrink(1);
                if (!itemEntityItem.isEmpty()) continue;
                e.discard();
                iter.remove();
            }
        }
    }
}

