/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.properties;

import com.satherov.crystalix.content.properties.IProperty;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class BooleanProperty
implements IProperty<Boolean> {
    private final ItemStack stack;
    private final DataComponentType<Boolean> componentType;
    private final String key;
    private final boolean enabled;
    private boolean value;

    public BooleanProperty(ItemStack stack, DataComponentType<Boolean> componentType, String key, boolean defaultValue, boolean enabled) {
        this.stack = stack;
        this.componentType = componentType;
        this.key = key;
        this.enabled = enabled;
        this.value = (Boolean)stack.getOrDefault(componentType, (Object)defaultValue);
    }

    public BooleanProperty(ItemStack stack, DataComponentType<Boolean> componentType, String key, boolean defaultValue) {
        this(stack, componentType, key, defaultValue, true);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValueString() {
        return this.value ? "enabled" : "disabled";
    }

    @Override
    public void setValueString(String val) {
        this.set(val.equals("enabled"));
    }

    @Override
    public void set(Boolean val) {
        if (!this.enabled) {
            return;
        }
        this.value = val;
        this.stack.set(this.componentType, (Object)val);
    }

    @Override
    public Boolean get() {
        return this.value;
    }

    @Override
    public Boolean next(boolean dir) {
        this.set(!this.value);
        return this.value;
    }

    @Override
    public Component toComponent() {
        return Component.translatable((String)this.getKeyTranslation()).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)this.getValueTranslation()).withStyle(this.get() != false ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
    }
}

