/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.properties;

import com.mojang.serialization.Codec;
import com.satherov.crystalix.content.CrystalixRegistry;
import com.satherov.crystalix.content.properties.BooleanProperty;
import com.satherov.crystalix.content.properties.EnumProperty;
import com.satherov.crystalix.content.properties.IProperty;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import org.jetbrains.annotations.Nullable;

public class BlockProperties {
    public final ItemStack wand;
    public final BooleanProperty shadeless;
    public final BooleanProperty reinforced;
    public final EnumProperty<Light> light;
    public final EnumProperty<Ghost> ghost;
    public final IProperty<?>[] properties;

    public BlockProperties(ItemStack wand) {
        this.wand = wand;
        this.shadeless = new BooleanProperty(wand, CrystalixRegistry.SHADELESS.get(), "shadeless", false);
        this.reinforced = new BooleanProperty(wand, CrystalixRegistry.REINFORCED.get(), "reinforced", false);
        this.light = new EnumProperty<Light>(wand, CrystalixRegistry.LIGHT.get(), "light", Light.class, Light.NONE);
        this.ghost = new EnumProperty<Ghost>(wand, CrystalixRegistry.GHOST.get(), "ghost", Ghost.class, Ghost.BLOCK_ALL);
        this.properties = new IProperty[]{this.shadeless, this.reinforced, this.light, this.ghost};
    }

    @Nullable
    public IProperty<?> get(String key) {
        for (IProperty<?> option : this.properties) {
            if (!option.getKey().equals(key)) continue;
            return option;
        }
        return null;
    }

    public static enum Light implements StringRepresentable
    {
        NONE(0),
        LIGHT(1),
        DARK(2),
        FAKE_LIGHT(3);

        private final int id;
        public static final Codec<Light> CODEC;
        private static final IntFunction<Light> BY_ID;
        public static final StreamCodec<ByteBuf, Light> STREAM_CODEC;

        private Light(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Light::values);
            BY_ID = ByIdMap.continuous(Light::getId, (Object[])Light.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Light::getId);
        }
    }

    public static enum Ghost implements StringRepresentable
    {
        BLOCK_ALL(0, context -> false),
        ALLOW_ALL(1, context -> true),
        BLOCK_PLAYER(2, context -> !(context.getEntity() instanceof Player)),
        ALLOW_PLAYER(3, context -> context.getEntity() instanceof Player),
        BLOCK_MONSTER(4, context -> !(context.getEntity() instanceof Monster)),
        ALLOW_MONSTER(5, context -> context.getEntity() instanceof Monster),
        BLOCK_ANIMAL(6, context -> !(context.getEntity() instanceof Animal)),
        ALLOW_ANIMAL(7, context -> context.getEntity() instanceof Animal);

        private final int id;
        private final Predicate<EntityCollisionContext> collisionPredicate;
        public static final Codec<Ghost> CODEC;
        private static final IntFunction<Ghost> BY_ID;
        public static final StreamCodec<ByteBuf, Ghost> STREAM_CODEC;

        private Ghost(int id, Predicate<EntityCollisionContext> collisionPredicate) {
            this.id = id;
            this.collisionPredicate = collisionPredicate;
        }

        public boolean canCollide(EntityCollisionContext context) {
            return this.collisionPredicate.test(context);
        }

        public int getId() {
            return this.id;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Ghost::values);
            BY_ID = ByIdMap.continuous(Ghost::getId, (Object[])Ghost.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Ghost::getId);
        }
    }
}

