/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.block;

import com.satherov.crystalix.content.CrystalixRegistry;
import com.satherov.crystalix.content.item.CrystalixWand;
import com.satherov.crystalix.content.properties.BlockProperties;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CrystalixGlass
extends TransparentBlock
implements LiquidBlockContainer {
    private final DyeColor color;
    public static final BooleanProperty SHADELESS = BooleanProperty.create((String)"shadeless");
    public static final BooleanProperty REINFORCED = BooleanProperty.create((String)"reinforced");
    public static final EnumProperty<BlockProperties.Light> LIGHT = EnumProperty.create((String)"light", BlockProperties.Light.class);
    public static final EnumProperty<BlockProperties.Ghost> GHOST = EnumProperty.create((String)"ghost", BlockProperties.Ghost.class);

    public CrystalixGlass(DyeColor dyeColor) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_STAINED_GLASS).mapColor(dyeColor));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SHADELESS, (Comparable)Boolean.valueOf(false))).setValue((Property)REINFORCED, (Comparable)Boolean.valueOf(false))).setValue(LIGHT, (Comparable)((Object)BlockProperties.Light.NONE))).setValue(GHOST, (Comparable)((Object)BlockProperties.Ghost.BLOCK_ALL)));
        this.color = dyeColor;
    }

    public Integer getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return this.color.getTextureDiffuseColor();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SHADELESS, REINFORCED, LIGHT, GHOST});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return this.defaultBlockState();
        }
        if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof CrystalixWand) {
            ItemStack wand = player.getItemInHand(InteractionHand.OFF_HAND);
            return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)SHADELESS, (Comparable)Objects.requireNonNull((Boolean)wand.get(CrystalixRegistry.SHADELESS)))).setValue((Property)REINFORCED, (Comparable)Objects.requireNonNull((Boolean)wand.get(CrystalixRegistry.REINFORCED)))).setValue(LIGHT, (Comparable)((Object)Objects.requireNonNull((BlockProperties.Light)((Object)wand.get(CrystalixRegistry.LIGHT)))))).setValue(GHOST, (Comparable)((Object)Objects.requireNonNull((BlockProperties.Ghost)((Object)wand.get(CrystalixRegistry.GHOST)))));
        }
        return this.defaultBlockState();
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)REINFORCED) == false && super.canDropFromExplosion(state, level, pos, explosion);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return (Boolean)state.getValue((Property)REINFORCED) == false && super.canBeReplaced(state, context);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!((Boolean)state.getValue((Property)REINFORCED)).booleanValue()) {
            super.onBlockExploded(state, level, pos, explosion);
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return (Boolean)state.getValue((Property)REINFORCED) == false;
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)REINFORCED) != false ? Float.MAX_VALUE : super.getExplosionResistance();
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getValue(LIGHT) != BlockProperties.Light.DARK;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state.getValue(LIGHT) == BlockProperties.Light.FAKE_LIGHT && level.getGameTime() % 4L == 0L) {
            level.getLightEngine().checkBlock(pos);
            level.sendBlockUpdated(pos, state, state, 2);
        }
    }

    protected int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getValue(LIGHT) == BlockProperties.Light.DARK ? level.getMaxLightLevel() : 0;
    }

    public int getLightEmission(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        BlockProperties.Light light = (BlockProperties.Light)((Object)state.getValue(LIGHT));
        if (light == BlockProperties.Light.FAKE_LIGHT) {
            return blockGetter instanceof ServerLevel ? 0 : 15;
        }
        if (light == BlockProperties.Light.LIGHT) {
            return 15;
        }
        return 0;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context) != CollisionContext.empty() && ((BlockProperties.Ghost)((Object)state.getValue(GHOST))).canCollide(entityCollisionContext)) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        if (Objects.requireNonNull(pathComputationType) == PathComputationType.LAND) {
            return state.getValue(GHOST) != BlockProperties.Ghost.ALLOW_ALL || state.getValue(GHOST) != BlockProperties.Ghost.ALLOW_MONSTER || state.getValue(GHOST) != BlockProperties.Ghost.ALLOW_ANIMAL;
        }
        return false;
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }
}

