/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.compat.jade;

import com.satherov.crystalix.content.block.CrystalixGlass;
import com.satherov.crystalix.content.properties.BlockProperties;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class CrystalixJadePlugin
implements IWailaPlugin {
    private static final ResourceLocation CRYSTALIX_BLOCK = ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)"crystalix_block");

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)CrystalixComponentProvider.INSTANCE, CrystalixGlass.class);
    }

    private static Component getTranslation(String key, boolean state) {
        return Component.translatable((String)String.format("%s.property.%s", "crystalix", key)).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ")).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)String.format("%s.property.%s.%s", "crystalix", key, state ? "enabled" : "disabled")).withStyle(state ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
    }

    private static Component getTranslation(String key, String state) {
        return Component.translatable((String)String.format("%s.property.%s", "crystalix", key)).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)String.format("%s.property.%s.%s", "crystalix", key, state)));
    }

    static enum CrystalixComponentProvider implements IBlockComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            tooltip.add(CrystalixJadePlugin.getTranslation("shadeless", (Boolean)accessor.getBlockState().getValue((Property)CrystalixGlass.SHADELESS)));
            tooltip.add(CrystalixJadePlugin.getTranslation("reinforced", (Boolean)accessor.getBlockState().getValue((Property)CrystalixGlass.REINFORCED)));
            tooltip.add(CrystalixJadePlugin.getTranslation("light", ((BlockProperties.Light)((Object)accessor.getBlockState().getValue(CrystalixGlass.LIGHT))).name().toLowerCase(Locale.ROOT)));
            tooltip.add(CrystalixJadePlugin.getTranslation("ghost", ((BlockProperties.Ghost)((Object)accessor.getBlockState().getValue(CrystalixGlass.GHOST))).name().toLowerCase(Locale.ROOT)));
        }

        public ResourceLocation getUid() {
            return CRYSTALIX_BLOCK;
        }
    }
}

