/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.items.ItemImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ItemRangeVisualizer
extends ItemImpl {
    public static final ListMultimap<ResourceLocation, BlockPos> VISUALIZED_BLOCKS = ArrayListMultimap.create();
    public static final ListMultimap<ResourceLocation, Entity> VISUALIZED_ENTITIES = ArrayListMultimap.create();
    public static final ListMultimap<ResourceLocation, BlockPos> VISUALIZED_RAILS = ArrayListMultimap.create();

    public ItemRangeVisualizer() {
        super("range_visualizer", new Item.Properties().stacksTo(1));
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public static void clear() {
        if (!VISUALIZED_BLOCKS.isEmpty()) {
            VISUALIZED_BLOCKS.clear();
        }
        if (!VISUALIZED_ENTITIES.isEmpty()) {
            VISUALIZED_ENTITIES.clear();
        }
        if (!VISUALIZED_RAILS.isEmpty()) {
            VISUALIZED_RAILS.clear();
        }
    }

    public static <T> void visualize(Player player, ListMultimap<ResourceLocation, T> map, ResourceLocation dim, T value) {
        if (map.containsEntry((Object)dim, value)) {
            map.remove((Object)dim, value);
            player.displayClientMessage((Component)Component.translatable((String)"info.naturesaura.range_visualizer.end"), true);
        } else {
            map.put((Object)dim, value);
            player.displayClientMessage((Component)Component.translatable((String)"info.naturesaura.range_visualizer.start"), true);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown()) {
            ItemRangeVisualizer.clear();
            playerIn.displayClientMessage((Component)Component.translatable((String)"info.naturesaura.range_visualizer.end_all"), true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        Block block = state.getBlock();
        if (block instanceof IVisualizable) {
            if (level.isClientSide) {
                ItemRangeVisualizer.visualize(context.getPlayer(), VISUALIZED_BLOCKS, level.dimension().location(), pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public class EventHandler {
        @SubscribeEvent
        public void onInteract(PlayerInteractEvent.EntityInteractSpecific event) {
            ItemStack stack = event.getItemStack();
            if (stack.isEmpty() || stack.getItem() != ItemRangeVisualizer.this) {
                return;
            }
            Entity entity = event.getTarget();
            if (entity instanceof IVisualizable) {
                if (entity.level().isClientSide) {
                    ResourceLocation dim = entity.level().dimension().location();
                    ItemRangeVisualizer.visualize(event.getEntity(), VISUALIZED_ENTITIES, dim, entity);
                }
                event.getEntity().swing(event.getHand());
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

