/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.data;

import de.ellpeck.naturesaura.gen.ModFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class BiomeModifiers {
    public static final ResourceKey<BiomeModifier> AURA_BLOOM = BiomeModifiers.createKey("aura_bloom");
    public static final ResourceKey<BiomeModifier> AURA_CACTUS = BiomeModifiers.createKey("aura_cactus");
    public static final ResourceKey<BiomeModifier> WARPED_AURA_MUSHROOM = BiomeModifiers.createKey("warped_aura_mushroom");
    public static final ResourceKey<BiomeModifier> CRIMSON_AURA_MUSHROOM = BiomeModifiers.createKey("crimson_aura_mushroom");
    public static final ResourceKey<BiomeModifier> AURA_MUSHROOM = BiomeModifiers.createKey("aura_mushroom");

    private static ResourceKey<BiomeModifier> createKey(String id) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"naturesaura", (String)id));
    }

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        HolderGetter placedGetter = context.lookup(Registries.PLACED_FEATURE);
        context.register(AURA_BLOOM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(ModFeatures.Placed.AURA_BLOOM)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(AURA_CACTUS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(Tags.Biomes.IS_SANDY), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(ModFeatures.Placed.AURA_CACTUS)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(AURA_MUSHROOM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(Tags.Biomes.IS_MUSHROOM), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(ModFeatures.Placed.AURA_MUSHROOM)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(CRIMSON_AURA_MUSHROOM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(BiomeTags.IS_NETHER), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(ModFeatures.Placed.CRIMSON_AURA_MUSHROOM)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(WARPED_AURA_MUSHROOM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(BiomeTags.IS_NETHER), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(ModFeatures.Placed.WARPED_AURA_MUSHROOM)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }
}

