/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import de.ellpeck.naturesaura.recipes.AltarRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorAltar
implements IComponentProcessor {
    private AltarRecipe recipe;

    public void setup(Level level, IVariableProvider provider) {
        this.recipe = (AltarRecipe)PatchouliCompat.getRecipe("altar", provider.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString());
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        return switch (key) {
            case "input" -> PatchouliCompat.ingredientVariable(this.recipe.input, (HolderLookup.Provider)level.registryAccess());
            case "output" -> IVariable.from((Object)this.recipe.output, (HolderLookup.Provider)level.registryAccess());
            case "catalyst" -> {
                if (this.recipe.catalyst != Ingredient.EMPTY) {
                    yield PatchouliCompat.ingredientVariable(this.recipe.catalyst, (HolderLookup.Provider)level.registryAccess());
                }
                yield null;
            }
            case "name" -> IVariable.wrap((String)this.recipe.output.getHoverName().getString(), (HolderLookup.Provider)level.registryAccess());
            default -> null;
        };
    }

    public boolean allowRender(String group) {
        return group.isEmpty() || this.recipe != null && group.equals(this.recipe.catalyst == Ingredient.EMPTY ? "altar" : "catalyst");
    }
}

