/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityMossGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockEntityMossGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.MOSS_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            if (this.level.getGameTime() % 20L != 0L) {
                return;
            }
            LevelData data = (LevelData)ILevelData.getLevelData(this.level);
            ArrayList<BlockPos> possibleOffsets = new ArrayList<BlockPos>();
            int range = 2;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos offset = this.worldPosition.offset(x, y, z);
                        boolean isRecent = data.recentlyConvertedMossStones.contains(offset);
                        BlockState state = this.level.getBlockState(offset);
                        if (NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.inverse().containsKey((Object)state)) {
                            if (isRecent) continue;
                            possibleOffsets.add(offset);
                            continue;
                        }
                        if (!isRecent) continue;
                        data.recentlyConvertedMossStones.remove(offset);
                    }
                }
            }
            if (possibleOffsets.isEmpty()) {
                return;
            }
            BlockPos offset = (BlockPos)possibleOffsets.get(this.level.random.nextInt(possibleOffsets.size()));
            BlockState state = this.level.getBlockState(offset);
            BlockState result = (BlockState)NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.inverse().get((Object)state);
            int toAdd = 5000;
            if (this.canGenerateRightNow(toAdd)) {
                this.generateAura(toAdd);
                PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles((float)offset.getX(), (float)offset.getY(), (float)offset.getZ(), PacketParticles.Type.MOSS_GENERATOR, new int[0]));
            }
            this.level.levelEvent(2001, offset, Block.getId((BlockState)state));
            this.level.setBlockAndUpdate(offset, result);
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }
}

