/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.handler;

import it.crystalnest.cobweb.api.block.BlockUtils;
import it.crystalnest.harvest_with_ease.Constants;
import it.crystalnest.harvest_with_ease.api.HarvestUtils;
import it.crystalnest.harvest_with_ease.api.event.HarvestEvent;
import it.crystalnest.harvest_with_ease.config.ModConfig;
import it.crystalnest.harvest_with_ease.platform.Services;
import java.math.BigDecimal;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.Nullable;

public abstract class HarvestHandler {
    protected HarvestHandler() {
    }

    protected static void handle(LevelAccessor level, BlockState crop, BlockPos pos) {
        try {
            if (!level.isClientSide() && ModConfig.getGrantedExp() > 0 && HarvestUtils.isCrop(crop.getBlock()) && HarvestUtils.isAllowed(crop) && HarvestUtils.isMature(crop) && ((ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
                ExperienceOrb.award((ServerLevel)((ServerLevel)level), (Vec3)Vec3.atCenterOf((Vec3i)pos), (int)ModConfig.getGrantedExp());
            }
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException e) {
            HarvestHandler.logError(e, pos);
        }
    }

    protected static boolean handle(Level level, BlockState crop, Direction face, BlockPos pos, BlockHitResult hitResult, Player player, InteractionHand hand) {
        boolean consume = false;
        if (hand != null && hand == HarvestHandler.getValidHand(player) && HarvestHandler.canHarvest(level, crop, pos, face, hitResult, player, hand)) {
            try {
                IntegerProperty age = HarvestUtils.getAge(crop);
                if (HarvestUtils.isMature(crop, age)) {
                    consume = true;
                    if (!level.isClientSide) {
                        int fromCenterToEdge;
                        TieredItem tool;
                        HarvestHandler.harvest((ServerLevel)level, age, crop, pos, pos, face, hitResult, (ServerPlayer)player, hand);
                        Item item = player.getItemInHand(hand).getItem();
                        if (item instanceof TieredItem && Services.HARVEST.isHoe((tool = (TieredItem)item).getDefaultInstance()) && HarvestUtils.isTierForMultiHarvest(tool) && (fromCenterToEdge = ((HarvestUtils.getTierLevel(tool) - HarvestUtils.getTierLevel(ResourceLocation.parse((String)ModConfig.getMultiHarvestStartingTier()))) * ModConfig.getAreaIncrementStep().step + ModConfig.getAreaStartingSize().size - 1) / 2) > 0) {
                            StreamSupport.stream(BlockPos.spiralAround((BlockPos)pos, (int)fromCenterToEdge, (Direction)player.getDirection(), (Direction)player.getDirection().getClockWise()).spliterator(), false).filter(cropPos -> {
                                BlockState cropState;
                                BlockState patt0$temp;
                                return !pos.equals(cropPos) && (patt0$temp = level.getBlockState((BlockPos)cropPos)) instanceof BlockState && HarvestHandler.canHarvest(level, cropState = patt0$temp, (BlockPos)cropPos, face, null, player, hand) && HarvestUtils.isMature(cropState);
                            }).forEach(cropPos -> HarvestHandler.harvest((ServerLevel)level, HarvestUtils.getAge(level.getBlockState((BlockPos)cropPos)), level.getBlockState((BlockPos)cropPos), (BlockPos)cropPos, pos, face, null, (ServerPlayer)player, hand));
                        }
                    }
                }
            }
            catch (ClassCastException | NullPointerException | NoSuchElementException e) {
                HarvestHandler.logError(e, pos);
            }
        }
        return consume;
    }

    private static void harvest(ServerLevel level, IntegerProperty age, BlockState crop, BlockPos pos, BlockPos originalPos, Direction face, BlockHitResult hitResult, ServerPlayer player, InteractionHand hand) {
        Services.EVENT.fireBeforeHarvestEvent(level, crop, pos, face, hitResult, player, hand);
        BlockPos basePos = HarvestHandler.getBasePos(level, crop.getBlock(), pos);
        HarvestHandler.grantExp(level, basePos);
        HarvestHandler.damageHoe(player, hand);
        HarvestHandler.updateCrop(level, age, crop.getBlock(), basePos, player, HarvestHandler.dropResources(level, level.getBlockState(basePos), basePos, originalPos, face, hitResult, player, hand));
        HarvestHandler.playSound(level, player, crop, pos);
        HarvestHandler.exhaustPlayer((Player)player);
        Services.EVENT.fireAfterHarvestEvent(level, crop, pos, face, hitResult, player, hand);
    }

    private static void updateCrop(ServerLevel level, IntegerProperty age, Block crop, BlockPos basePos, ServerPlayer player, boolean customDrops) {
        if (crop == Blocks.PITCHER_CROP) {
            int i = player.getInventory().findSlotMatchingItem(crop.getCloneItemStack((LevelReader)level, basePos, level.getBlockState(basePos)));
            if (i >= 0 || player.isCreative()) {
                level.setBlockAndUpdate(basePos, (BlockState)level.getBlockState(basePos).setValue((Property)age, (Comparable)Integer.valueOf(0)));
                if (!player.isCreative()) {
                    player.getInventory().getItem(i).shrink(1);
                }
            } else {
                level.destroyBlock(basePos, !customDrops, (Entity)player);
            }
        } else {
            level.setBlockAndUpdate(basePos, (BlockState)level.getBlockState(basePos).setValue((Property)age, (Comparable)Integer.valueOf(0)));
        }
        if (level.getBlockState(basePos).is(BlockTags.CROPS) && level.getBlockState(basePos.above()).is(crop) && !HarvestHandler.isTallButSeparate(crop)) {
            level.destroyBlock(basePos.above(), !customDrops, (Entity)player);
        }
    }

    private static BlockPos getBasePos(ServerLevel level, Block crop, BlockPos pos) {
        BlockPos basePos = pos;
        while (level.getBlockState(pos).is(BlockTags.CROPS) && !HarvestHandler.isTallButSeparate(crop) && level.getBlockState(basePos.below()).is(crop)) {
            basePos = basePos.below();
        }
        return basePos;
    }

    private static void grantExp(ServerLevel level, BlockPos pos) {
        if (ModConfig.getGrantedExp() > 0 && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            ExperienceOrb.award((ServerLevel)level, (Vec3)Vec3.atCenterOf((Vec3i)pos), (int)ModConfig.getGrantedExp());
        }
    }

    private static void damageHoe(ServerPlayer player, InteractionHand hand) {
        if (ModConfig.getRequireHoe().booleanValue() && ModConfig.getDamageOnHarvest() > 0 && !player.isCreative()) {
            player.getItemInHand(hand).hurtAndBreak(ModConfig.getDamageOnHarvest().intValue(), (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
    }

    private static boolean dropResources(ServerLevel level, BlockState crop, BlockPos pos, BlockPos originalPos, Direction face, @Nullable BlockHitResult hitResult, ServerPlayer player, InteractionHand hand) {
        if (level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            HarvestEvent.HarvestDropsEvent event = Services.EVENT.fireHarvestDropsEvent(level, crop, pos, face, hitResult, player, hand);
            HarvestHandler.dropStacks(level, ModConfig.getGatherDrops() != false ? originalPos : pos, face, event.getDrops());
            return event.didDropsChange();
        }
        return false;
    }

    private static void playSound(ServerLevel level, ServerPlayer player, BlockState crop, BlockPos pos) {
        SoundType soundType = Services.HARVEST.getSoundType(level, player, crop, pos);
        level.playSound(null, pos, soundType.getBreakSound(), SoundSource.BLOCKS, soundType.getVolume(), soundType.getPitch());
    }

    private static void exhaustPlayer(Player player) {
        if (ModConfig.getExhaustionMultiplier().compareTo(BigDecimal.ZERO) > 0) {
            player.causeFoodExhaustion(0.005f * ModConfig.getExhaustionMultiplier().floatValue());
        }
    }

    @Nullable
    private static InteractionHand getValidHand(Player player) {
        if (!player.isCrouching()) {
            if (Services.HARVEST.isHoe(player.getMainHandItem())) {
                return InteractionHand.MAIN_HAND;
            }
            if (Services.HARVEST.isHoe(player.getOffhandItem())) {
                return InteractionHand.OFF_HAND;
            }
            if (!ModConfig.getRequireHoe().booleanValue()) {
                return InteractionHand.MAIN_HAND;
            }
        }
        return null;
    }

    private static boolean canHarvest(Level level, BlockState crop, BlockPos pos, Direction face, @Nullable BlockHitResult hitResult, Player player, InteractionHand hand) {
        return HarvestUtils.isCrop(crop.getBlock()) && player.hasCorrectToolForDrops(crop) && HarvestUtils.hasEnoughHunger(player) && HarvestUtils.isAllowed(crop) && Services.EVENT.fireHarvestCheckEvent(level, crop, pos, face, hitResult, player, hand);
    }

    private static void dropStacks(ServerLevel level, BlockPos pos, Direction face, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos) != Shapes.empty()) {
                Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)face, (ItemStack)stack);
                continue;
            }
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
    }

    private static boolean isTallButSeparate(Block crop) {
        return "farmersdelight:tomatoes".equalsIgnoreCase(BlockUtils.getStringKey((Block)crop));
    }

    private static void logError(Exception e, BlockPos pos) {
        Constants.LOGGER.debug("Exception generated by block at [{}]", (Object)pos.toShortString());
        Constants.LOGGER.debug("This is a non blocking error, but can result in incorrect behavior for mod {}", (Object)"harvest_with_ease");
        Constants.LOGGER.debug("Most likely, it wasn't possible to retrieve a crop age property, either for an invalid item in the cropIds configuration option or for a mod incompatibility; see stack trace for more details", (Throwable)e);
    }
}

