/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class PlayerUtil {
    public static void healPlayer(Player player, float amount) {
        player.setHealth(Math.min(player.getMaxHealth(), player.getHealth() + amount));
    }

    public static void teleportPlayer(Player player, BlockPos pos) {
        player.teleportTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
    }

    public static boolean giveItemToPlayer(Player player, ItemStack itemStack) {
        int freeSpace = PlayerUtil.calculateFreeSpaceForItem(player, itemStack);
        if (freeSpace >= itemStack.getCount()) {
            player.getInventory().add(itemStack);
            return true;
        }
        if (freeSpace > 0) {
            ItemStack stackToAdd = itemStack.copy();
            stackToAdd.setCount(freeSpace);
            player.getInventory().add(stackToAdd);
        }
        ItemStack remainingStack = itemStack.copy();
        remainingStack.setCount(itemStack.getCount() - freeSpace);
        PlayerUtil.dropItemNearPlayer(player, remainingStack);
        return false;
    }

    private static int calculateFreeSpaceForItem(Player player, ItemStack itemStack) {
        int freeSpace = 0;
        int maxStackSize = itemStack.getMaxStackSize();
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty()) {
                freeSpace += maxStackSize;
            } else if (stack == itemStack) {
                freeSpace += maxStackSize - stack.getCount();
            }
            if (freeSpace < itemStack.getCount()) continue;
            return itemStack.getCount();
        }
        return freeSpace;
    }

    private static void dropItemNearPlayer(Player player, ItemStack itemStack) {
        Level level = player.level();
        if (!level.isClientSide && !itemStack.isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(level, player.getX(), player.getY() + 0.5, player.getZ(), itemStack);
            itemEntity.setPickUpDelay(40);
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    public static boolean transferItemBetweenPlayers(Player fromPlayer, Player toPlayer, ItemStack itemStack, int amount) {
        ItemStack stackToTransfer = itemStack.copy();
        stackToTransfer.setCount(amount);
        if (fromPlayer.getInventory().contains(stackToTransfer)) {
            fromPlayer.getInventory().removeItem(stackToTransfer);
            boolean addedToReceiver = toPlayer.getInventory().add(stackToTransfer);
            if (!addedToReceiver) {
                PlayerUtil.dropItemNearPlayer(toPlayer, stackToTransfer);
            }
            return true;
        }
        return false;
    }

    public static boolean giveItemIfConditionsMet(Player player, int requiredYLevel, int requiredExperience, ItemStack itemStack) {
        if (player.getY() > (double)requiredYLevel && player.experienceLevel >= requiredExperience) {
            return PlayerUtil.giveItemToPlayer(player, itemStack);
        }
        return false;
    }

    public static boolean hasFreeInventorySlots(Player player, int requiredSlots) {
        long freeSlots = player.getInventory().items.stream().filter(ItemStack::isEmpty).count();
        return freeSlots >= (long)requiredSlots;
    }

    public static void setPlayerHunger(Player player, int amount) {
        player.getFoodData().setFoodLevel(Math.min(20, Math.max(0, amount)));
    }

    public static boolean isPlayerAboveYLevel(Player player, double yLevel) {
        return player.getY() > yLevel;
    }

    public static void killPlayer(Player player) {
        player.setHealth(0.0f);
    }

    public static void launchPlayer(Player player, Vec3 direction, double velocity) {
        Vec3 normalizedDirection = direction.normalize();
        player.setDeltaMovement(normalizedDirection.scale(velocity));
        player.hasImpulse = true;
    }

    public static void freezePlayer(Player player, int freezeTicks) {
        player.setTicksFrozen(freezeTicks);
    }

    public static boolean isPlayerInWater(Player player) {
        return player.isInWater();
    }

    public static void applyPotionEffect(Player player, Holder<MobEffect> effect, int duration, int amplifier) {
        player.addEffect(new MobEffectInstance(effect, duration, amplifier));
    }

    public static void pushPlayerAwayFromEntity(Player player, Entity entity, double force) {
        Vec3 direction = player.position().subtract(entity.position()).normalize();
        player.setDeltaMovement(direction.scale(force));
        player.hasImpulse = true;
    }

    public static void setPlayerGlowing(Player player, int duration) {
        PlayerUtil.applyPotionEffect(player, (Holder<MobEffect>)MobEffects.GLOWING, duration, 0);
    }

    public static boolean isPlayerWithinDistance(Player player, BlockPos pos, double maxDistance) {
        return player.blockPosition().closerThan((Vec3i)pos, maxDistance);
    }

    public static boolean tryGiveItem(Player player, ItemStack stack) {
        if (player.getInventory().getFreeSlot() != -1) {
            player.getInventory().add(stack);
            return true;
        }
        return false;
    }

    private static void teleportToWorldSpawn(Player player) {
        BlockPos worldSpawn = player.level().getSharedSpawnPos();
        player.teleportTo((double)worldSpawn.getX(), (double)worldSpawn.getY(), (double)worldSpawn.getZ());
    }

    public static Entity findClosestEntity(Player player, double maxDistance, Predicate<Entity> condition) {
        return player.level().getEntities((Entity)player, player.getBoundingBox().inflate(maxDistance), condition).stream().min(Comparator.comparingDouble(e -> e.distanceTo((Entity)player))).orElse(null);
    }

    public static String getFormattedInventoryString(Player player) {
        return player.getInventory().items.stream().filter(itemStack -> !itemStack.isEmpty()).map(itemStack -> itemStack.getItem().getDescriptionId() + " x" + itemStack.getCount()).collect(Collectors.joining(", "));
    }

    public static boolean isPlayerHoldingAnyItemFromList(Player player, List<ItemStack> itemList) {
        return itemList.stream().anyMatch(item -> player.getMainHandItem().getItem().equals(item.getItem()));
    }

    public static <T extends Entity> List<T> findEntitiesAroundPlayer(Player player, Class<T> entityType, double radius) {
        return player.level().getEntitiesOfClass(entityType, player.getBoundingBox().inflate(radius));
    }

    public static void randomTeleport(Player player, double range) {
        double randomX = player.getX() + (Math.random() - 0.5) * range * 2.0;
        double randomZ = player.getZ() + (Math.random() - 0.5) * range * 2.0;
        double y = player.level().getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)randomX, (int)randomZ);
        player.teleportTo(randomX, y, randomZ);
    }

    public static void fullyHealAndFeedPlayer(Player player) {
        player.setHealth(player.getMaxHealth());
        player.getFoodData().setFoodLevel(20);
        player.getFoodData().setSaturation(20.0f);
    }

    public static BlockPos findNearestBlockOfType(Player player, List<Block> blockTypes, double radius) {
        BlockPos playerPos = player.blockPosition();
        BlockPos nearestBlock = null;
        double closestDistance = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)playerPos.offset((int)(-radius), (int)(-radius), (int)(-radius)), (BlockPos)playerPos.offset((int)radius, (int)radius, (int)radius))) {
            double distance;
            if (!blockTypes.contains(player.level().getBlockState(pos).getBlock()) || !((distance = playerPos.distSqr((Vec3i)pos)) < closestDistance)) continue;
            closestDistance = distance;
            nearestBlock = pos;
        }
        return nearestBlock;
    }

    public static int calculateInventoryValue(Player player, Map<Item, Integer> itemValues) {
        return player.getInventory().items.stream().filter(itemStack -> !itemStack.isEmpty() && itemValues.containsKey(itemStack.getItem())).mapToInt(itemStack -> (Integer)itemValues.get(itemStack.getItem()) * itemStack.getCount()).sum();
    }

    public static void executeRunnableAtLocation(Player player, BlockPos targetPos, double radius, Runnable runnable) {
        if (player.blockPosition().closerThan((Vec3i)targetPos, radius)) {
            runnable.run();
        }
    }

    public static void logPlayerState(Player player) {
        System.out.printf("Player Position: [x: %.2f, y: %.2f, z: %.2f]%n", player.getX(), player.getY(), player.getZ());
        System.out.println("Inventory: " + PlayerUtil.getFormattedInventoryString(player));
    }

    public static void sortInventoryByItemName(Player player) {
        List<ItemStack> sortedItems = player.getInventory().items.stream().filter(itemStack -> !itemStack.isEmpty()).sorted(Comparator.comparing(itemStack -> itemStack.getItem().getDescriptionId())).toList();
        ItemStack[] armorBackup = new ItemStack[4];
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            armorBackup[slot.getIndex()] = (ItemStack)player.getInventory().armor.get(slot.getIndex());
        }
        ItemStack offhandBackup = (ItemStack)player.getInventory().offhand.get(0);
        player.getInventory().clearContent();
        for (int i = 0; i < sortedItems.size() && i < player.getInventory().items.size(); ++i) {
            player.getInventory().setItem(i, sortedItems.get(i));
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            player.getInventory().armor.set(slot.getIndex(), (Object)armorBackup[slot.getIndex()]);
        }
        player.getInventory().offhand.set(0, (Object)offhandBackup);
    }
}

