/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class ItemStackUtil {
    public static boolean hasItemAmount(Player player, Item item, int count) {
        int totalCount = 0;
        for (ItemStack stack : player.getInventory().items) {
            if (stack.getItem() != item || (totalCount += stack.getCount()) < count) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItemFromPlayer(Player player, Item item, int count) {
        int remaining = count;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.getItem() != item) continue;
            int stackCount = stack.getCount();
            if (stackCount > remaining) {
                stack.shrink(remaining);
                return true;
            }
            remaining -= stackCount;
            player.getInventory().setItem(i, ItemStack.EMPTY);
        }
        return remaining <= 0;
    }

    public static void clearEnchantments(ItemStack stack) {
        if (stack.isEnchanted()) {
            EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)ItemEnchantments.EMPTY);
        }
    }

    public static ItemStack setCustomName(ItemStack stack, String name) {
        if (stack == null) {
            throw new IllegalArgumentException("ItemStack cannot be null");
        }
        MutableComponent customName = Component.literal((String)name);
        stack.set(DataComponents.CUSTOM_NAME, (Object)customName);
        return stack;
    }

    public static boolean hasEnchantment(ItemStack stack, Enchantment enchantment) {
        if (stack == null || enchantment == null) {
            return false;
        }
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            Holder enchantmentHolder = (Holder)entry.getKey();
            if (!((Enchantment)enchantmentHolder.value()).equals((Object)enchantment)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack combineEnchantments(ItemStack stack1, ItemStack stack2) {
        if (stack1.getItem() != stack2.getItem()) {
            return stack1;
        }
        ItemEnchantments enchantments2 = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack2);
        EnchantmentHelper.updateEnchantments((ItemStack)stack1, enchantments1Mutable -> {
            for (Object2IntMap.Entry entry : enchantments2.entrySet()) {
                Holder enchantmentHolder = (Holder)entry.getKey();
                int levelFromStack2 = entry.getIntValue();
                int existingLevel = enchantments1Mutable.getLevel(enchantmentHolder);
                int newLevel = Math.max(existingLevel, levelFromStack2);
                enchantments1Mutable.set(enchantmentHolder, newLevel);
            }
        });
        return stack1;
    }

    public static List<ItemStack> splitStack(ItemStack stack, int size) {
        int splitSize;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int remaining = stack.getCount(); remaining > 0; remaining -= splitSize) {
            splitSize = Math.min(size, remaining);
            ItemStack splitStack = stack.copy();
            splitStack.setCount(splitSize);
            result.add(splitStack);
        }
        return result;
    }

    public static boolean repairItem(ItemStack stack, int repairAmount) {
        if (!stack.isDamageableItem() || stack.getDamageValue() == 0) {
            return false;
        }
        int newDamage = stack.getDamageValue() - repairAmount;
        stack.setDamageValue(Math.max(newDamage, 0));
        return true;
    }

    public static boolean fullyRepairItem(ItemStack stack) {
        if (!stack.isDamageableItem() || stack.getDamageValue() == 0) {
            return false;
        }
        stack.setDamageValue(0);
        return true;
    }

    public static boolean canStacksBeCombined(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return false;
        }
        return stack1.getItem() == stack2.getItem() && stack1.getDamageValue() == stack2.getDamageValue() && !stack1.isEnchanted() && !stack2.isEnchanted();
    }

    public static int getTotalDurability(ItemStack stack) {
        if (!stack.isDamageableItem()) {
            return 0;
        }
        return stack.getMaxDamage();
    }

    public static int getRemainingDurability(ItemStack stack) {
        if (!stack.isDamageableItem()) {
            return 0;
        }
        return stack.getMaxDamage() - stack.getDamageValue();
    }
}

