/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class ChatUtil {
    public static MutableComponent createFormattedMessage(String prefix, String message, ChatFormatting ... format) {
        String finalMessage = (prefix != null ? prefix : "") + message;
        return Component.literal((String)finalMessage).withStyle(format);
    }

    public static MutableComponent createFormattedTranslatableMessage(String prefix, String translationKey, Object[] args, ChatFormatting ... format) {
        String finalPrefix = prefix != null ? prefix : "";
        MutableComponent translatableMessage = Component.translatable((String)translationKey, (Object[])args);
        return Component.literal((String)finalPrefix).append((Component)translatableMessage).withStyle(format);
    }

    public static void sendChatMessage(Player player, MutableComponent message) {
        if (player.level().isClientSide) {
            player.sendSystemMessage((Component)message);
        }
    }

    public static void sendChatMessage(Player player, String prefix, String message, ChatFormatting ... format) {
        ChatUtil.sendChatMessage(player, ChatUtil.createFormattedMessage(prefix, message, format));
    }

    public static void addServerChatMessage(Player player, Component message) {
        if (!player.level().isClientSide) {
            player.sendSystemMessage(message);
        }
    }

    public static void addServerChatMessage(Player player, String prefix, String message, ChatFormatting ... format) {
        ChatUtil.addServerChatMessage(player, (Component)ChatUtil.createFormattedMessage(prefix, message, format));
    }

    public static String blockPosToString(BlockPos pos) {
        return pos.getX() + ", " + pos.getY() + ", " + pos.getZ();
    }

    public static void sendStatusMessage(Player player, String prefix, String message, ChatFormatting ... format) {
        player.displayClientMessage((Component)ChatUtil.createFormattedMessage(prefix, message, format), true);
    }

    public static void sendFeedback(CommandContext<CommandSourceStack> context, String prefix, String message, ChatFormatting ... format) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ChatUtil.createFormattedMessage(prefix, message, format), false);
    }

    public static void sendColoredMessage(Player player, String message, ChatFormatting color) {
        MutableComponent coloredMessage = ChatUtil.createFormattedMessage("", message, new ChatFormatting[0]).withStyle(color);
        player.sendSystemMessage((Component)coloredMessage);
    }

    public static void sendErrorMessage(Player player, String message) {
        ChatUtil.sendColoredMessage(player, message, ChatFormatting.RED);
    }

    public static void sendSuccessMessage(Player player, String message) {
        ChatUtil.sendColoredMessage(player, message, ChatFormatting.GREEN);
    }

    public static void sendWarningMessage(Player player, String message) {
        ChatUtil.sendColoredMessage(player, message, ChatFormatting.YELLOW);
    }

    public static void broadcastMessage(Iterable<Player> players, String message) {
        for (Player player : players) {
            ChatUtil.sendChatMessage(player, "", message, new ChatFormatting[0]);
        }
    }

    public static void broadcastServerMessage(Iterable<Player> players, String message) {
        for (Player player : players) {
            ChatUtil.addServerChatMessage(player, "", message, new ChatFormatting[0]);
        }
    }

    public static void broadcastFormattedMessage(Iterable<Player> players, String prefix, String message, ChatFormatting ... format) {
        for (Player player : players) {
            ChatUtil.addServerChatMessage(player, prefix, message, format);
        }
    }

    public static void sendPositionalMessage(Player player, String prefix, BlockPos pos) {
        String posString = ChatUtil.blockPosToString(pos);
        ChatUtil.sendChatMessage(player, prefix, "Position: " + posString, ChatFormatting.GRAY);
    }

    public static void logMessageToConsole(String prefix, String message, ChatFormatting formatting) {
        MutableComponent consoleMessage = ChatUtil.createFormattedMessage(prefix, message, formatting);
        System.out.println(consoleMessage.getString());
    }
}

