/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockUtil {
    public static boolean isAirBlock(ServerLevel level, BlockPos pos) {
        return level.getBlockState(pos).isAir();
    }

    public static void replaceBlock(ServerLevel level, BlockPos pos, Block newBlock) {
        level.setBlockAndUpdate(pos, newBlock.defaultBlockState());
    }

    public static void dropBlockAsItem(ServerLevel level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)pos);
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
    }

    public static boolean isBlockSolid(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.isSolidRender((BlockGetter)level, pos);
    }

    public static boolean tryPlaceBlock(ServerLevel level, BlockPos pos, Block block, Player player) {
        if (level.getBlockState(pos).isAir()) {
            level.setBlockAndUpdate(pos, block.defaultBlockState());
            return true;
        }
        return false;
    }

    public static float getBlockHardness(ServerLevel level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        return blockState.getDestroySpeed((BlockGetter)level, pos);
    }

    public static boolean isBlockExposedToSunlight(ServerLevel level, BlockPos pos) {
        return level.canSeeSky(pos);
    }

    public static boolean breakBlockAsPlayer(ServerLevel level, BlockPos pos, Player player) {
        BlockState blockState = level.getBlockState(pos);
        if (blockState.getDestroySpeed((BlockGetter)level, pos) >= 0.0f) {
            blockState.getBlock().playerDestroy((Level)level, player, pos, blockState, null, player.getMainHandItem());
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            return true;
        }
        return false;
    }

    public static boolean isBlockSurroundedBySolidBlocks(ServerLevel level, BlockPos pos) {
        return BlockUtil.isBlockSolid(level, pos.above()) && BlockUtil.isBlockSolid(level, pos.below()) && BlockUtil.isBlockSolid(level, pos.north()) && BlockUtil.isBlockSolid(level, pos.south()) && BlockUtil.isBlockSolid(level, pos.west()) && BlockUtil.isBlockSolid(level, pos.east());
    }

    public static int countBlockInArea(ServerLevel level, BlockPos fromPos, BlockPos toPos, Block blockToCount) {
        int count = 0;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)fromPos, (BlockPos)toPos)) {
            if (!level.getBlockState(pos).is(blockToCount)) continue;
            ++count;
        }
        return count;
    }

    public static void destroyBlocksInArea(ServerLevel level, BlockPos fromPos, BlockPos toPos, boolean dropItems) {
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)fromPos, (BlockPos)toPos)) {
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) continue;
            if (dropItems) {
                Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
            }
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public static BlockPos findFirstSolidBlockBelow(ServerLevel level, BlockPos pos) {
        BlockPos currentPos = pos.below();
        while (currentPos.getY() > level.getMinBuildHeight()) {
            if (!level.getBlockState(currentPos).isAir()) {
                return currentPos;
            }
            currentPos = currentPos.below();
        }
        return null;
    }

    public static Set<Block> getBlocksInArea(ServerLevel level, BlockPos fromPos, BlockPos toPos) {
        return BlockPos.betweenClosedStream((BlockPos)fromPos, (BlockPos)toPos).map(pos -> level.getBlockState(pos).getBlock()).collect(Collectors.toSet());
    }

    public static boolean placeBlockWithValidation(ServerLevel level, BlockPos pos, Block block, BlockPlaceContext context) {
        BlockState blockState = block.defaultBlockState();
        if (blockState.canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, blockState, 3);
            return true;
        }
        return false;
    }

    public static void replaceMostFrequentBlock(ServerLevel level, BlockPos fromPos, BlockPos toPos, Block replacementBlock) {
        Map<Block, Long> blockFrequency = BlockPos.betweenClosedStream((BlockPos)fromPos, (BlockPos)toPos).map(pos -> level.getBlockState(pos).getBlock()).collect(Collectors.groupingBy(block -> block, Collectors.counting()));
        blockFrequency.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).ifPresent(mostFrequentBlock -> BlockPos.betweenClosedStream((BlockPos)fromPos, (BlockPos)toPos).filter(pos -> level.getBlockState(pos).getBlock() == mostFrequentBlock).forEach(pos -> level.setBlockAndUpdate(pos, replacementBlock.defaultBlockState())));
    }

    public static Stream<BlockPos> getBlocksWithCondition(ServerLevel level, BlockPos fromPos, BlockPos toPos, Predicate<BlockState> condition) {
        return BlockPos.betweenClosedStream((BlockPos)fromPos, (BlockPos)toPos).filter(pos -> condition.test(level.getBlockState(pos)));
    }

    public static void replaceBlocksWithCondition(ServerLevel level, BlockPos fromPos, BlockPos toPos, Predicate<BlockState> condition, Block replacementBlock) {
        BlockPos.betweenClosedStream((BlockPos)fromPos, (BlockPos)toPos).filter(pos -> condition.test(level.getBlockState(pos))).forEach(pos -> level.setBlockAndUpdate(pos, replacementBlock.defaultBlockState()));
    }
}

