/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.records;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;

public record AreaProtectionData(String regionName, BlockPos corner1, BlockPos corner2, List<ServerPlayer> allowedPlayers, boolean isProtected) {
    public boolean isPlayerAllowed(ServerPlayer player) {
        return this.allowedPlayers.contains(player);
    }

    public boolean isPositionInProtectedArea(BlockPos position) {
        return position.getX() >= Math.min(this.corner1.getX(), this.corner2.getX()) && position.getX() <= Math.max(this.corner1.getX(), this.corner2.getX()) && position.getY() >= Math.min(this.corner1.getY(), this.corner2.getY()) && position.getY() <= Math.max(this.corner1.getY(), this.corner2.getY()) && position.getZ() >= Math.min(this.corner1.getZ(), this.corner2.getZ()) && position.getZ() <= Math.max(this.corner1.getZ(), this.corner2.getZ());
    }

    public void allowPlayer(ServerPlayer player) {
        this.allowedPlayers.add(player);
    }

    @Override
    public String toString() {
        return "Protected area [" + this.regionName + "] from " + String.valueOf(this.corner1) + " to " + String.valueOf(this.corner2) + " [Players allowed: " + this.allowedPlayers.size() + "]";
    }
}

