/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.compat.registry;

import dev.xylonity.knightlib.KnightLibCommon;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class KnightLibItems {
    public static final Supplier<Item> SMALL_ESSENCE = KnightLibItems.registerItem("small_essence", () -> new KnightLibItem(new Item.Properties(), "small_essence"));
    public static final Supplier<Item> GREAT_ESSENCE = KnightLibItems.registerItem("great_essence", () -> new KnightLibItem(new Item.Properties(), "great_essence"));

    public static void init() {
    }

    private static <T extends Item> Supplier<T> registerItem(String id, Supplier<T> item) {
        return KnightLibCommon.COMMON_PLATFORM.registerItem(id, item);
    }

    private static class KnightLibItem
    extends Item {
        private final String tooltipInfoName;

        public KnightLibItem(Item.Properties properties, String tooltipInfoName) {
            super(properties);
            this.tooltipInfoName = tooltipInfoName;
        }

        public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
            pTooltipComponents.add((Component)Component.translatable((String)("tooltip.item.knightlib." + this.tooltipInfoName)));
            super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        }
    }
}

