/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Pos3D
extends Vec3 {
    public Pos3D() {
        this(0.0, 0.0, 0.0);
    }

    public Pos3D(double x, double y, double z) {
        super(x, y, z);
    }

    public Pos3D(Vec3 vec) {
        this(vec.x, vec.y, vec.z);
    }

    public Pos3D(Entity entity) {
        this(entity.getX(), entity.getY(), entity.getZ());
    }

    public static Pos3D create(BlockEntity tile) {
        return Pos3D.create((Vec3i)tile.getBlockPos());
    }

    public static Pos3D create(Vec3i vec) {
        return new Pos3D(vec.getX(), vec.getY(), vec.getZ());
    }

    public static Pos3D read(CompoundTag tag) {
        return new Pos3D(tag.getDouble("x"), tag.getDouble("y"), tag.getDouble("z"));
    }

    public static Pos3D translateMatrix(double[] matrix, Pos3D translation) {
        double x = translation.x * matrix[0] + translation.y * matrix[1] + translation.z * matrix[2] + matrix[3];
        double y = translation.x * matrix[4] + translation.y * matrix[5] + translation.z * matrix[6] + matrix[7];
        double z = translation.x * matrix[8] + translation.y * matrix[9] + translation.z * matrix[10] + matrix[11];
        return new Pos3D(x, y, z);
    }

    public static double[] getRotationMatrix(float angle, Pos3D axis) {
        return axis.getRotationMatrix(angle);
    }

    public static double anglePreNorm(Pos3D pos1, Pos3D pos2) {
        return Math.acos(pos1.dot(pos2));
    }

    public static AABB getAABB(Pos3D pos1, Pos3D pos2) {
        return new AABB(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public CompoundTag write(CompoundTag nbtTags) {
        nbtTags.putDouble("x", this.x);
        nbtTags.putDouble("y", this.y);
        nbtTags.putDouble("z", this.z);
        return nbtTags;
    }

    public Pos3D diff(Vec3 vec) {
        return new Pos3D(this.x - vec.x, this.y - vec.y, this.z - vec.z);
    }

    public Pos3D centre() {
        return this.translate(0.5, 0.5, 0.5);
    }

    public Pos3D translate(double x, double y, double z) {
        return new Pos3D(this.x + x, this.y + y, this.z + z);
    }

    public Pos3D translate(Vec3 pos) {
        return this.translate(pos.x, pos.y, pos.z);
    }

    public Pos3D translate(Vec3 ... positions) {
        double x = this.x;
        double y = this.y;
        double z = this.z;
        for (Vec3 position : positions) {
            x += position.x;
            y += position.y;
            z += position.z;
        }
        return new Pos3D(x, y, z);
    }

    public Pos3D translate(Direction direction, double amount) {
        return this.translate((double)direction.getNormal().getX() * amount, (double)direction.getNormal().getY() * amount, (double)direction.getNormal().getZ() * amount);
    }

    public Pos3D translateExcludingSide(Direction direction, double amount) {
        double xPos = this.x;
        double yPos = this.y;
        double zPos = this.z;
        if (direction.getAxis() != Direction.Axis.X) {
            xPos += amount;
        }
        if (direction.getAxis() != Direction.Axis.Y) {
            yPos += amount;
        }
        if (direction.getAxis() != Direction.Axis.Z) {
            zPos += amount;
        }
        return new Pos3D(xPos, yPos, zPos);
    }

    public Pos3D adjustPosition(Direction direction, Entity entity) {
        if (direction.getAxis() == Direction.Axis.X) {
            return new Pos3D(entity.getX(), this.y, this.z);
        }
        if (direction.getAxis() == Direction.Axis.Y) {
            return new Pos3D(this.x, entity.getY(), this.z);
        }
        return new Pos3D(this.x, this.y, entity.getZ());
    }

    public double distance(Vec3 pos) {
        double subX = this.x - pos.x;
        double subY = this.y - pos.y;
        double subZ = this.z - pos.z;
        return Math.sqrt(subX * subX + subY * subY + subZ * subZ);
    }

    @Nonnull
    public Pos3D yRot(float yaw) {
        double yawRadians = Math.toRadians(yaw);
        double xPos = this.x;
        double zPos = this.z;
        if (yaw != 0.0f) {
            xPos = this.x * Math.cos(yawRadians) - this.z * Math.sin(yawRadians);
            zPos = this.z * Math.cos(yawRadians) + this.x * Math.sin(yawRadians);
        }
        return new Pos3D(xPos, this.y, zPos);
    }

    @Nonnull
    public Pos3D xRot(float pitch) {
        double pitchRadians = Math.toRadians(pitch);
        double yPos = this.y;
        double zPos = this.z;
        if (pitch != 0.0f) {
            yPos = this.y * Math.cos(pitchRadians) - this.z * Math.sin(pitchRadians);
            zPos = this.z * Math.cos(pitchRadians) + this.y * Math.sin(pitchRadians);
        }
        return new Pos3D(this.x, yPos, zPos);
    }

    public Pos3D rotate(float yaw, float pitch) {
        return this.rotate(yaw, pitch, 0.0f);
    }

    public Pos3D rotate(float yaw, float pitch, float roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double xPos = this.x * Math.cos(yawRadians) * Math.cos(pitchRadians) + this.z * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + this.y * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        double zPos = this.x * Math.sin(yawRadians) * Math.cos(pitchRadians) + this.z * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + this.y * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        double yPos = -this.x * Math.sin(pitchRadians) + this.z * Math.cos(pitchRadians) * Math.sin(rollRadians) + this.y * Math.cos(pitchRadians) * Math.cos(rollRadians);
        return new Pos3D(xPos, yPos, zPos);
    }

    public Pos3D multiply(Vec3 pos) {
        return this.scale(pos.x, pos.y, pos.z);
    }

    public Pos3D scale(double x, double y, double z) {
        return new Pos3D(this.x * x, this.y * y, this.z * z);
    }

    @Nonnull
    public Pos3D scale(double scale) {
        return this.scale(scale, scale, scale);
    }

    public Pos3D rotate(float angle, Pos3D axis) {
        return Pos3D.translateMatrix(Pos3D.getRotationMatrix(angle, axis), this);
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Pos3D axis = this.clone().normalize();
        double x = axis.x;
        double y = axis.y;
        double z = axis.z;
        double angleAsRadian = Math.toRadians(angle);
        float cos = (float)Math.cos(angleAsRadian);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angleAsRadian);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z * (double)sin;
        matrix[2] = x * z * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z * (double)ocos + x * (double)sin;
        matrix[8] = x * z * (double)ocos + y * (double)sin;
        matrix[9] = y * z * (double)ocos - x * (double)sin;
        matrix[10] = z * z * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public Pos3D normalize() {
        return new Pos3D(super.normalize());
    }

    public double anglePreNorm(Pos3D pos2) {
        return Math.acos(this.dot(pos2));
    }

    public Pos3D xCrossProduct() {
        return new Pos3D(0.0, this.z, -this.y);
    }

    public Pos3D zCrossProduct() {
        return new Pos3D(-this.y, this.x, 0.0);
    }

    public Pos3D getPerpendicular() {
        return this.z == 0.0 ? this.zCrossProduct() : this.xCrossProduct();
    }

    public Pos3D floor() {
        return new Pos3D(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Pos3D clone() {
        return new Pos3D(this.x, this.y, this.z);
    }

    @Nonnull
    public String toString() {
        return "[Pos3D: " + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Vec3 && ((Vec3)obj).x == this.x && ((Vec3)obj).y == this.y && ((Vec3)obj).z == this.z;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + new Double(this.x).hashCode();
        code = 31 * code + new Double(this.y).hashCode();
        code = 31 * code + new Double(this.z).hashCode();
        return code;
    }
}

