/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ArmorItem;

public enum ArmorRenderType implements StringRepresentable
{
    ALL(true, true),
    ARMOR_ONLY(true, false, ArmorItem.Type.HELMET, ArmorItem.Type.CHESTPLATE),
    ADDITION_ONLY(false, true, ArmorItem.Type.HELMET, ArmorItem.Type.CHESTPLATE),
    NONE(false, false);

    public static final Codec<ArmorRenderType> CODEC;
    public static final IntFunction<ArmorRenderType> BY_ID;
    public static final StreamCodec<ByteBuf, ArmorRenderType> STREAM_CODEC;
    private final ArmorItem.Type[] allowedTypes;
    private final boolean renderArmor;
    private final boolean renderAddition;

    private ArmorRenderType(boolean renderArmor, boolean renderAddition, ArmorItem.Type ... allowedTypes) {
        this.allowedTypes = allowedTypes;
        this.renderArmor = renderArmor;
        this.renderAddition = renderAddition;
    }

    private ArmorRenderType(boolean renderArmor, boolean renderAddition) {
        this(renderArmor, renderAddition, ArmorItem.Type.values());
    }

    public boolean canBeSelected(ArmorItem item) {
        return Arrays.stream(this.allowedTypes).anyMatch(t -> item.getType().equals(t));
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    public boolean shouldRenderArmor() {
        return this.renderArmor;
    }

    public boolean shouldRenderAddition() {
        return this.renderAddition;
    }

    static {
        CODEC = StringRepresentable.fromValues(ArmorRenderType::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ArmorRenderType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

