/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.CreateQOLClient;
import fr.iglee42.createqualityoflife.statue.Statue;
import fr.iglee42.createqualityoflife.statue.StatueArmorModel;
import fr.iglee42.createqualityoflife.statue.StatueCapeLayer;
import fr.iglee42.createqualityoflife.statue.StatueModel;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class StatueRenderer
extends LivingEntityRenderer<Statue, StatueModel> {
    public static final ResourceLocation STATUE_LOCATION = CreateQOL.asResource("textures/entity/statue.png");
    public static final ResourceLocation STATUE_SPECIAL_1 = CreateQOL.asResource("textures/entity/statue_delta.png");
    public static final ResourceLocation STATUE_SPECIAL_2 = CreateQOL.asResource("textures/entity/statue_sus.png");

    public StatueRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new StatueModel(context.bakeLayer(CreateQOLClient.STATUE), false), 0.0f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new StatueArmorModel(context.bakeLayer(CreateQOLClient.STATUE_INNER_ARMOR)), new StatueArmorModel(context.bakeLayer(CreateQOLClient.STATUE_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer(new StatueCapeLayer((RenderLayerParent<Statue, StatueModel>)this));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
    }

    public static Optional<PlayerSkin> getPlayerProfileTexture(Statue statue) {
        return statue.getProfile().map(ResolvableProfile::gameProfile).map(gameProfile -> {
            Minecraft minecraft = Minecraft.getInstance();
            return minecraft.getSkinManager().getInsecureSkin(gameProfile);
        });
    }

    public void render(Statue entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        this.setModelProperties(entity);
        super.render((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public Vec3 getRenderOffset(Statue entity, float partialTicks) {
        return entity.isCrouching() ? new Vec3(0.0, -0.125, 0.0) : super.getRenderOffset((Entity)entity, partialTicks);
    }

    private void setModelProperties(Statue entity) {
        StatueModel model = (StatueModel)this.getModel();
        model.setAllVisible(true);
        model.hat.visible = entity.isPartShown(PlayerModelPart.HAT);
        model.jacket.visible = entity.isPartShown(PlayerModelPart.JACKET);
        model.leftPants.visible = entity.isPartShown(PlayerModelPart.LEFT_PANTS_LEG);
        model.rightPants.visible = entity.isPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
        model.leftSleeve.visible = model.slimLeftSleeve.visible = entity.isPartShown(PlayerModelPart.LEFT_SLEEVE);
        model.rightSleeve.visible = model.slimRightSleeve.visible = entity.isPartShown(PlayerModelPart.RIGHT_SLEEVE);
        model.crouching = entity.isCrouching();
    }

    public ResourceLocation getTextureLocation(Statue entity) {
        if (entity.getSkin() == 1) {
            return STATUE_SPECIAL_1;
        }
        if (entity.getSkin() == 2) {
            return STATUE_SPECIAL_2;
        }
        return StatueRenderer.getPlayerProfileTexture(entity).map(PlayerSkin::texture).orElse(STATUE_LOCATION);
    }

    protected void scale(Statue livingEntity, PoseStack matrixStack, float partialTickTime) {
        float modelScale = Mth.lerp((float)partialTickTime, (float)livingEntity.entityScaleO, (float)livingEntity.getEntityScale());
        matrixStack.scale(modelScale *= 0.9375f, modelScale, modelScale);
    }

    protected void setupRotations(Statue entityLiving, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        float entityZRotation = Mth.lerp((float)partialTicks, (float)entityLiving.entityRotationsO.getZ(), (float)entityLiving.getEntityZRotation());
        float entityYRotation = Mth.lerp((float)partialTicks, (float)entityLiving.entityRotationsO.getY(), (float)entityLiving.getYRot());
        float entityXRotation = Mth.lerp((float)partialTicks, (float)entityLiving.entityRotationsO.getX(), (float)entityLiving.getEntityXRotation());
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f - entityZRotation));
        matrixStack.mulPose(Axis.YP.rotationDegrees(entityYRotation));
        matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f - entityXRotation));
        float hurtAmount = (float)(entityLiving.level().getGameTime() - entityLiving.lastHit) + partialTicks;
        if (hurtAmount < 5.0f) {
            matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(hurtAmount / 1.5f * (float)Math.PI)) * 3.0f));
        }
        if (StatueRenderer.isEntityUpsideDown((LivingEntity)entityLiving)) {
            matrixStack.translate(0.0, (double)(entityLiving.getBbHeight() - 0.0625f), 0.0);
            matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected boolean shouldShowName(Statue entity) {
        double d = this.entityRenderDispatcher.distanceToSqr((Entity)entity);
        float f = entity.isCrouching() ? 32.0f : 64.0f;
        return !(d >= (double)(f * f)) && entity.isCustomNameVisible();
    }

    @Nullable
    protected RenderType getRenderType(Statue livingEntity, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (!livingEntity.isMarker()) {
            return super.getRenderType((LivingEntity)livingEntity, bodyVisible, translucent, glowing);
        }
        ResourceLocation resourceLocation = this.getTextureLocation(livingEntity);
        if (translucent) {
            return RenderType.entityTranslucent((ResourceLocation)resourceLocation, (boolean)false);
        }
        return bodyVisible ? RenderType.entityCutoutNoCull((ResourceLocation)resourceLocation, (boolean)false) : null;
    }
}

