/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets.entries;

import fr.iglee42.createqualityoflife.client.screens.ArmorConfigScreen;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.ValueEntry;
import fr.iglee42.createqualityoflife.packets.ChangeArmorComponentPacket;
import java.util.List;
import java.util.Locale;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.FadableScreenElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.element.TextStencilElement;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class EnumEntry
extends ValueEntry<Enum<?>> {
    protected static final int cycleWidth = 34;
    protected TextStencilElement valueText;
    protected BoxWidget cycleLeft;
    protected BoxWidget cycleRight;

    public EnumEntry(String label, Enum<?> value, DataComponentType<?> component, String ... comments) {
        super(label, value, component, comments);
        this.valueText = new TextStencilElement(Minecraft.getInstance().font, "YEP").centered(true, true);
        this.valueText.withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient((GuiGraphics)ms, (float)0.0f, (int)0, (int)(height / 2), (float)height, (float)width, (Couple)UIRenderHelper.COLOR_TEXT));
        DelegatedStencilElement l = PonderGuiTextures.ICON_CONFIG_PREV.asStencil();
        this.cycleLeft = (BoxWidget)new BoxWidget(0, 0, 42, 16).withCustomBackground(BoxElement.COLOR_BACKGROUND_FLAT).showingElement((RenderElement)l).withCallback(() -> this.cycleValue(-1));
        l.withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(this.cycleLeft));
        DelegatedStencilElement r = PonderGuiTextures.ICON_CONFIG_NEXT.asStencil();
        this.cycleRight = (BoxWidget)new BoxWidget(0, 0, 42, 16).withCustomBackground(BoxElement.COLOR_BACKGROUND_FLAT).showingElement((RenderElement)r).withCallback(() -> this.cycleValue(1));
        r.at(26.0f, 0.0f);
        r.withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(this.cycleRight));
        this.listeners.add(this.cycleLeft);
        this.listeners.add(this.cycleRight);
        this.onReset();
    }

    protected void cycleValue(int direction) {
        Enum e = (Enum)this.getValue();
        Enum[] options = (Enum[])e.getDeclaringClass().getEnumConstants();
        e = options[Math.floorMod(e.ordinal() + direction, options.length)];
        this.setValue(e);
        this.bumpCog((float)direction * 15.0f);
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        this.cycleLeft.active = b;
        this.cycleLeft.animateGradientFromState();
        this.cycleRight.active = b;
        this.cycleRight.animateGradientFromState();
    }

    @Override
    public void tick() {
        super.tick();
        this.cycleLeft.tick();
        this.cycleRight.tick();
    }

    @Override
    public void render(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.render(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        this.cycleLeft.setX(x + this.getLabelWidth(width) + 4);
        this.cycleLeft.setY(y + 10);
        this.cycleLeft.render(graphics, mouseX, mouseY, partialTicks);
        this.valueText.at((float)(this.cycleLeft.getX() + 34 - 8), (float)(y + 10), 200.0f).withBounds(width - this.getLabelWidth(width) - 68 - 4 - 28, 16).render(graphics);
        this.cycleRight.setX(x + width - 68 - 28 + 10);
        this.cycleRight.setY(y + 10);
        this.cycleRight.render(graphics, mouseX, mouseY, partialTicks);
        new BoxElement().withBackground(BoxElement.COLOR_BACKGROUND_FLAT).flatBorder(0x1000000).withBounds(48, 6).at((float)(this.cycleLeft.getX() + 22), (float)(this.cycleLeft.getY() + 5)).render(graphics);
    }

    @Override
    public void onValueChange(Enum<?> newValue) {
        super.onValueChange(newValue);
        this.valueText.withText(ConfigScreen.toHumanReadable((String)newValue.name().toLowerCase(Locale.ROOT)));
    }

    @Override
    public void setValue(@NotNull Enum<?> value) {
        List<Integer> armors = ((ArmorConfigScreen)Minecraft.getInstance().screen).getArmors();
        int selected = ((ArmorConfigScreen)Minecraft.getInstance().screen).getSelectedItem();
        PacketDistributor.sendToServer((CustomPacketPayload)new ChangeArmorComponentPacket(armors.get(selected), value.ordinal(), BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)this.component).toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.setValue(value);
    }
}

