/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ItemConfigButton
extends BoxWidget {
    public static final Couple<Color> COLOR_IDLE = Couple.create((Object)new Color(1623245055, true), (Object)new Color(817938687, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_HOVER = Couple.create((Object)new Color(-255803137, true), (Object)new Color(-1597980417, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_CLICK = Couple.create((Object)new Color(-1, true), (Object)new Color(-570425345, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_DISABLED = Couple.create((Object)new Color(-2138009456, true), (Object)new Color(0x20909090, true)).map(Color::setImmutable);
    @Nullable
    protected ItemStack item;
    @Nullable
    protected int index;
    @Nullable
    protected KeyMapping shortcut;
    protected LerpedFloat flash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, (double)0.1f, LerpedFloat.Chaser.EXP);
    private final Consumer<ItemConfigButton> onClick;

    public ItemConfigButton(int x, int y, Consumer<ItemConfigButton> onClick, int index) {
        this(x, y, 20, 20, onClick, index);
    }

    public ItemConfigButton(int x, int y, int width, int height, Consumer<ItemConfigButton> onClick, int index) {
        super(x, y, width, height);
        this.onClick = onClick;
        this.index = index;
        this.z = 420.0f;
        this.paddingX = 2.0f;
        this.paddingY = 2.0f;
        this.colorIdle = COLOR_IDLE;
        this.colorHover = COLOR_HOVER;
        this.colorClick = COLOR_CLICK;
        this.colorDisabled = COLOR_DISABLED;
        this.updateGradientFromState();
    }

    public <T extends ItemConfigButton> T showing(ItemStack item) {
        this.item = item;
        return (T)((Object)((ItemConfigButton)super.showingElement(GuiGameElement.of((ItemStack)item).scale(1.5).at(-4.0f, -4.0f))));
    }

    public void flash() {
        this.flash.updateChaseTarget(1.0f);
    }

    public void dim() {
        this.flash.updateChaseTarget(0.0f);
    }

    public void tick() {
        super.tick();
        this.flash.tickChaser();
    }

    protected void beforeRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(graphics, mouseX, mouseY, partialTicks);
        float flashValue = this.flash.getValue(partialTicks);
        if (flashValue > 0.1f) {
            float sin = 0.5f + 0.5f * Mth.sin((float)(((float)AnimationTickHolder.getTicks((boolean)true) + partialTicks) / 10.0f));
            Color nc1 = new Color(255, 255, 255, Mth.clamp((int)(((Color)this.gradientColor.getFirst()).getAlpha() + 150), (int)0, (int)255));
            Color nc2 = new Color(155, 155, 155, Mth.clamp((int)(((Color)this.gradientColor.getSecond()).getAlpha() + 150), (int)0, (int)255));
            Couple newColors = Couple.create((Object)nc1, (Object)nc2);
            float finalSin = sin *= flashValue;
            this.gradientColor = this.gradientColor.mapWithParams((color, other) -> color.mixWith(other, finalSin), newColors);
        }
    }

    public void doRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.doRender(graphics, mouseX, mouseY, partialTicks);
        float fadeValue = this.fade.getValue();
        if (fadeValue < 0.1f) {
            return;
        }
        if (this.shortcut != null) {
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, this.z + 10.0f);
            graphics.drawCenteredString(Minecraft.getInstance().font, this.shortcut.getTranslatedKeyMessage().getString().toLowerCase(Locale.ROOT), this.getX() + this.width / 2 + 8, this.getY() + this.height - 6, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).scaleAlpha(fadeValue).getRGB());
            poseStack.popPose();
        }
    }

    public boolean isFocused() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.shortcut != null && this.shortcut.matches(keyCode, scanCode)) {
            this.gradientColor = this.getColorClick();
            this.startGradientAnimation(this.getColorForState(), 0.15);
            this.runCallback((float)this.width / 2.0f, (float)this.height / 2.0f);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClick(double x, double y) {
        super.onClick(x, y);
        this.onClick.accept(this);
    }

    @Nullable
    public ItemStack getItem() {
        return this.item;
    }

    public int getIndex() {
        return this.index;
    }
}

