/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.tabs;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import fr.iglee42.createqualityoflife.client.screens.ConfigureStatueScreen;
import fr.iglee42.createqualityoflife.client.screens.tabs.StatueTab;
import fr.iglee42.createqualityoflife.client.screens.widgets.StatueAnimationWidget;
import fr.iglee42.createqualityoflife.statue.animation.PublishedAnimationsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.world.item.Items;

public class PublishedAnimationsTab
extends StatueTab {
    private int selected = 6;
    private List<StatueAnimationWidget> animations;
    private IconButton previousButton;
    private IconButton nextButton;

    public PublishedAnimationsTab(int index, ConfigureStatueScreen parent) {
        super(index, Items.BOOKSHELF, parent, "statue.publishedAnimationTab");
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y) {
        this.animations.forEach(p -> {
            p.visible = this.animations.indexOf(p) >= this.selected - 6 && this.animations.indexOf(p) < this.selected;
        });
        this.previousButton.active = this.selected > 6;
        this.nextButton.active = this.selected < this.animations.size();
    }

    @Override
    public void forEachWidgets(Consumer<AbstractWidget> function) {
        this.animations.forEach(function);
        function.accept((AbstractWidget)this.nextButton);
        function.accept((AbstractWidget)this.previousButton);
    }

    @Override
    public void initWidgets(int x, int y) {
        this.animations = new ArrayList<StatueAnimationWidget>();
        for (PublishedAnimationsManager.PublishedAnimation anim : PublishedAnimationsManager.CLIENT_ANIMATIONS) {
            int index = this.animations.size() % 6;
            int indexInPos = index % 3;
            this.animations.add(new StatueAnimationWidget(x + indexInPos * 45, y + (index > 2 ? 80 : 0), anim, this));
        }
        this.previousButton = new IconButton(this.getParent().getGuiLeft() + this.getParent().imageWidth - 95, this.getParent().getGuiTop() + this.getParent().imageHeight - 24, (ScreenElement)AllIcons.I_CONFIG_BACK);
        this.previousButton.withCallback(() -> {
            if (this.selected > 6) {
                this.selected -= 6;
            }
        });
        this.nextButton = new IconButton(this.getParent().getGuiLeft() + this.getParent().imageWidth - 75, this.getParent().getGuiTop() + this.getParent().imageHeight - 24, (ScreenElement)AllIcons.I_CONFIG_OPEN);
        this.nextButton.withCallback(() -> {
            int maxIndex = (this.animations.size() - 1) / 6 * 6;
            if (this.selected + 6 <= maxIndex + 6) {
                this.selected += 6;
            }
        });
    }

    public void updateAnimationsPos(int x, int y) {
        for (int index = 0; index < this.animations.size(); ++index) {
            int indexInPos = index % 3;
            this.animations.get(index).setX(x + indexInPos * 45);
            this.animations.get(index).setY(y + (index > 2 ? 80 : 0));
        }
    }

    public List<StatueAnimationWidget> getAnimations() {
        return this.animations;
    }

    @Override
    public void onQuit() {
        super.onQuit();
    }
}

