/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.tabs.AnimationTab;
import fr.iglee42.createqualityoflife.client.screens.tabs.InventoryTab;
import fr.iglee42.createqualityoflife.client.screens.tabs.MainStatueTab;
import fr.iglee42.createqualityoflife.client.screens.tabs.PartsRotationTab;
import fr.iglee42.createqualityoflife.client.screens.tabs.PublishedAnimationsTab;
import fr.iglee42.createqualityoflife.client.screens.tabs.RotationPresetsTab;
import fr.iglee42.createqualityoflife.client.screens.tabs.SkinStatueTab;
import fr.iglee42.createqualityoflife.client.screens.tabs.StatueTab;
import fr.iglee42.createqualityoflife.client.screens.tabs.StatueTransformTab;
import fr.iglee42.createqualityoflife.client.screens.widgets.ItemButton;
import fr.iglee42.createqualityoflife.packets.SaveStatueConfigPacket;
import fr.iglee42.createqualityoflife.registries.ModEntityTypes;
import fr.iglee42.createqualityoflife.registries.ModGuiTextures;
import fr.iglee42.createqualityoflife.registries.ModItems;
import fr.iglee42.createqualityoflife.statue.Statue;
import fr.iglee42.createqualityoflife.statue.StatueMenu;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConfigureStatueScreen
extends AbstractSimiContainerScreen<StatueMenu> {
    private LinkedList<Integer> lastPressedKeys = new LinkedList();
    private Statue exampleStatue;
    private List<StatueTab> tabs;
    private int currentTab;
    private int oCurrentTab = -1;
    private IconButton possesButton;
    private IconButton confirmButton;
    private IconButton hideButton;
    private boolean hideBackground = false;
    private boolean wasAnimationPlaying;

    public ConfigureStatueScreen(StatueMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    protected void init() {
        ModGuiTextures bg = ModGuiTextures.STATUE;
        this.setWindowSize(bg.width, bg.height);
        this.setWindowOffset(0, 0);
        super.init();
        this.wasAnimationPlaying = ((Statue)((Object)((StatueMenu)this.menu).contentHolder)).isAnimationPlaying();
        ((Statue)((Object)((StatueMenu)this.menu).contentHolder)).setAnimationPlaying(false);
        this.confirmButton = new IconButton(this.leftPos + bg.width - 25, this.topPos + bg.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> {
            this.onClose();
            this.minecraft.player.closeContainer();
        });
        this.hideButton = new IconButton(this.leftPos + bg.width - 55, this.topPos + bg.height - 24, (ScreenElement)AllIcons.I_MTD_SCAN);
        this.hideButton.withCallback(() -> {
            this.setHideBackground(!this.isHideBackground());
            int currentTab = this.currentTab;
            this.resize(Minecraft.getInstance(), this.width, this.height);
            this.oCurrentTab = 0;
            this.currentTab = currentTab;
        });
        this.hideButton.getToolTip().add(CreateQOLLang.translateDirect("statue.hideBackground", new Object[0]));
        this.hideButton.getToolTip().add(CreateQOLLang.translateDirect("statue.hideBackground1", new Object[0]));
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.addRenderableWidget((GuiEventListener)this.hideButton);
        this.exampleStatue = new Statue((EntityType<? extends LivingEntity>)((EntityType)ModEntityTypes.STATUE.get()), (Level)Minecraft.getInstance().level);
        if (((StatueMenu)this.menu).contentHolder != null) {
            CompoundTag tag = new CompoundTag();
            ((Statue)((Object)((StatueMenu)this.menu).contentHolder)).saveWithoutId(tag);
            this.exampleStatue.load(tag);
        }
        this.tabs = new ArrayList<StatueTab>();
        this.tabs.add(new MainStatueTab(this.tabs.size(), this));
        this.tabs.add(new SkinStatueTab(this.tabs.size(), this));
        this.tabs.add(new StatueTransformTab(this.tabs.size(), this));
        this.tabs.add(new PartsRotationTab(this.tabs.size(), Items.PLAYER_HEAD.asItem(), this, PlayerModelPart.HAT));
        this.tabs.add(new PartsRotationTab(this.tabs.size(), ModItems.SHADOW_RADIANCE_CHESTPLATE.asItem(), this, PlayerModelPart.LEFT_SLEEVE, PlayerModelPart.RIGHT_SLEEVE));
        this.tabs.add(new PartsRotationTab(this.tabs.size(), ModItems.SHADOW_RADIANCE_LEGGINGS.asItem(), this, PlayerModelPart.LEFT_PANTS_LEG, PlayerModelPart.RIGHT_PANTS_LEG));
        this.tabs.add(new InventoryTab(this.tabs.size(), this));
        this.tabs.add(new RotationPresetsTab(this.tabs.size(), this));
        this.tabs.add(new AnimationTab(this.tabs.size(), this));
        this.tabs.add(new PublishedAnimationsTab(this.tabs.size(), this));
        this.tabs.forEach(t -> {
            ItemButton btn = (ItemButton)this.addRenderableWidget((GuiEventListener)new ItemButton(this.leftPos + this.imageWidth + 2, this.topPos + 10 + t.getIndex() * 20, t.getItem().getDefaultInstance(), b -> {
                this.currentTab = t.getIndex();
            }));
            if (btn.getIcon().is(Items.PLAYER_HEAD)) {
                ItemStack stack = Items.PLAYER_HEAD.getDefaultInstance();
                stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Minecraft.getInstance().getGameProfile()));
                btn.setIcon(stack);
            }
            btn.getToolTip().add(t.getTooltips());
            t.initWidgets(this.leftPos + 87 + (this.hideBackground ? 110 : 0), this.topPos + 30);
        });
        this.currentTab = 0;
        if (!this.exampleStatue.hasOwner()) {
            this.possesButton = (IconButton)new IconButton(this.leftPos + 7 + this.font.width("No Owner"), this.topPos + bg.height - 26, (ScreenElement)AllIcons.I_TARGET).withCallback(() -> this.exampleStatue.setOwner(Minecraft.getInstance().player.getUUID()));
            this.possesButton.getToolTip().add(CreateQOLLang.translateDirect("statue.ownStatue", new Object[0]));
            this.possesButton.getToolTip().add(CreateQOLLang.translateDirect("statue.ownStatue1", new Object[0]));
            this.addRenderableWidget((GuiEventListener)this.possesButton);
        }
        ((StatueMenu)this.getMenu()).setShowSlots(false);
    }

    public void renderBackground(GuiGraphics p_295206_, int p_295457_, int p_294596_, float p_296351_) {
        if (!this.hideBackground) {
            super.renderBackground(p_295206_, p_295457_, p_294596_, p_296351_);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.renderables.contains(this.possesButton) && this.exampleStatue.hasOwner()) {
            this.removeWidget((GuiEventListener)this.possesButton);
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics graphics, float v, int i, int i1) {
        ModGuiTextures.STATUE.render(graphics, this.leftPos, this.topPos);
    }

    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        MutableComponent toDraw;
        for (int slot = 0; slot < ((StatueMenu)this.getMenu()).ghostInventory.getSlots(); ++slot) {
            this.getExampleStatue().setItemSlot(EquipmentSlot.values()[slot], ((StatueMenu)this.getMenu()).ghostInventory.getStackInSlot(slot));
        }
        if (!this.hideBackground) {
            graphics.drawString(Minecraft.getInstance().font, "Customize your Statue", this.getGuiLeft() + 5, this.getGuiTop() + 3, 0xFFFFFF);
        }
        int offsetX = 10;
        int offsetY = 30;
        int size = 160;
        if (this.oCurrentTab != this.currentTab) {
            this.tabs.stream().filter(t -> t.getIndex() == this.oCurrentTab).forEach(t -> {
                t.forEachWidgets(arg_0 -> ((ConfigureStatueScreen)this).removeWidget(arg_0));
                t.forEachWidgets(arg_0 -> ((ConfigureStatueScreen)this).removeWidget(arg_0));
                t.onQuit();
            });
            this.tabs.stream().filter(t -> t.getIndex() == this.currentTab).findFirst().ifPresent(t -> t.forEachWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            }));
            this.oCurrentTab = this.currentTab;
        }
        if (this.exampleStatue != null && !this.hideBackground) {
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(this.leftPos + offsetX), (int)(this.topPos + offsetY), (int)(this.leftPos + offsetX + 67), (int)(this.topPos + offsetY + size), (int)50, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)this.exampleStatue);
        }
        this.tabs.stream().filter(t -> t.getIndex() == this.currentTab).findAny().ifPresent(t -> t.render(graphics, mouseX, mouseY, partialTicks, this.leftPos + 2 * offsetX + 67 + (this.hideBackground ? 110 : 0), this.topPos + offsetY));
        this.children().stream().filter(c -> c instanceof ItemButton).map(ItemButton.class::cast).forEach(btn -> btn.setActive(this.tabs.stream().noneMatch(tab -> btn.getIcon().is(tab.getItem()) && this.currentTab == tab.getIndex())));
        this.children().stream().filter(c -> c instanceof ItemButton).map(ItemButton.class::cast).forEach(btn -> {
            btn.visible = !this.hideBackground;
        });
        boolean bl = this.confirmButton.visible = !this.hideBackground;
        MutableComponent mutableComponent = this.exampleStatue.hasOwner() && Minecraft.getInstance().level != null ? (Minecraft.getInstance().level.getPlayerByUUID(this.exampleStatue.getOwner().get()) != null ? CreateQOLLang.translateDirect("statue.owner", Minecraft.getInstance().level.getPlayerByUUID(this.exampleStatue.getOwner().get()).getName().getString()) : CreateQOLLang.translateDirect("statue.unknow_owner", new Object[0])) : (toDraw = CreateQOLLang.translateDirect("statue.no_owner", new Object[0]));
        if (!this.hideBackground) {
            graphics.drawScrollingString(this.font, (Component)toDraw, this.leftPos + 5, this.leftPos + 66, this.topPos + ModGuiTextures.STATUE.height - 21, 0xFFFFFF);
        }
        if (!CreateQOLLang.translateDirect(this.tabs.get(this.currentTab).getKey() + ".desc", new Object[0]).getString().isEmpty() && !this.hideBackground) {
            boolean infoHovered;
            boolean bl2 = infoHovered = mouseX >= this.getGuiLeft() + this.imageWidth - 18 && mouseX <= this.getGuiLeft() + this.imageWidth - 2 && mouseY >= this.getGuiTop() && mouseY <= this.getGuiTop() + 16;
            if (infoHovered) {
                ModGuiTextures.INFO_ICON_HOVER.render(graphics, this.getGuiLeft() + this.imageWidth - 18, this.getGuiTop());
            } else {
                ModGuiTextures.INFO_ICON.render(graphics, this.getGuiLeft() + this.imageWidth - 18, this.getGuiTop());
            }
            if (infoHovered) {
                graphics.renderComponentTooltip(this.font, List.of(CreateQOLLang.translateDirect(this.tabs.get(this.currentTab).getKey() + ".desc", new Object[0])), mouseX, mouseY);
            }
        }
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    public Statue getExampleStatue() {
        return this.exampleStatue;
    }

    public void onClose() {
        this.tabs.stream().filter(t -> t.getIndex() == this.currentTab).forEach(StatueTab::onQuit);
        this.getExampleStatue().setAnimationPlaying(this.wasAnimationPlaying);
        this.sendUpdatePacket();
        super.onClose();
    }

    public void sendUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.exampleStatue.saveWithoutId(nbt);
        if (((StatueMenu)this.menu).contentHolder != null) {
            if (this.getExampleStatue().hasOwner() && !Minecraft.getInstance().player.getUUID().equals(this.getExampleStatue().getOwner().get())) {
                nbt.putBoolean("Invulnerable", ((Statue)((Object)((StatueMenu)this.menu).contentHolder)).isInvulnerable());
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new SaveStatueConfigPacket(((Statue)((Object)((StatueMenu)this.menu).contentHolder)).getId(), nbt), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        StatueTransformTab tab;
        StatueTab statueTab;
        if (pModifiers == 0) {
            this.lastPressedKeys.add(pKeyCode);
            if (this.lastPressedKeys.size() > 10) {
                this.lastPressedKeys.poll();
            }
            if (this.checkKonamiCode()) {
                if (this.getExampleStatue().getSkin() == 0) {
                    this.getExampleStatue().setSkin(2);
                } else if (this.getExampleStatue().getSkin() == 2) {
                    this.getExampleStatue().setSkin(0);
                }
            }
        }
        if ((statueTab = this.tabs.get(this.currentTab)) instanceof StatueTransformTab && (tab = (StatueTransformTab)statueTab).keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void setHideBackground(boolean hideBackground) {
        this.hideBackground = hideBackground;
    }

    public boolean isHideBackground() {
        return this.hideBackground;
    }

    public void resize(Minecraft p_96575_, int p_96576_, int p_96577_) {
        this.tabs.stream().filter(t -> t.getIndex() == this.currentTab).findFirst().ifPresent(t -> t.forEachWidgets(arg_0 -> ((ConfigureStatueScreen)this).removeWidget(arg_0)));
        super.resize(p_96575_, p_96576_, p_96577_);
        this.tabs.stream().filter(t -> t.getIndex() == this.currentTab).findFirst().ifPresent(t -> t.forEachWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }));
    }

    public List<Rect2i> getExtraAreas() {
        if (!this.hideBackground) {
            return super.getExtraAreas();
        }
        int x = this.leftPos + 20 + 67 + 110;
        return List.of(new Rect2i(x, this.topPos + 30, this.imageWidth - 67, 160), new Rect2i(this.leftPos + this.imageWidth + 2, this.topPos + 10, 20, (this.tabs.size() - 1) * 20));
    }

    private boolean checkKonamiCode() {
        return this.lastPressedKeys.size() == 10 && this.lastPressedKeys.get(0).equals(265) && this.lastPressedKeys.get(1).equals(265) && this.lastPressedKeys.get(2).equals(264) && this.lastPressedKeys.get(3).equals(264) && this.lastPressedKeys.get(4).equals(263) && this.lastPressedKeys.get(5).equals(262) && this.lastPressedKeys.get(6).equals(263) && this.lastPressedKeys.get(7).equals(262) && this.lastPressedKeys.get(8).equals(66) && (this.lastPressedKeys.get(9).equals(81) || this.lastPressedKeys.get(9).equals(65));
    }
}

