/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import fr.iglee42.createqualityoflife.registries.ModBlockEntities;
import fr.iglee42.createqualityoflife.utils.TrashItemHandler;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TrashCanBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    TrashItemHandler itemHandler;
    private final EnumMap<Direction, BlockCapabilityCache<IItemHandler, @Nullable Direction>> capCaches = new EnumMap(Direction.class);

    public TrashCanBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler = new TrashItemHandler(this);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.TRASH_CAN.get(), (be, context) -> be.itemHandler);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
    }

    public boolean canAcceptItem(ItemStack stack) {
        return true;
    }

    protected int getExtractionAmount() {
        return 16;
    }

    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return ItemHelper.ExtractionCountMode.UPTO;
    }

    protected boolean canActivate() {
        return true;
    }

    protected void handleInputFromAbove() {
        this.handleInput(this.grabCapability(Direction.UP));
    }

    protected void handleInput(@Nullable IItemHandler inv) {
        if (inv == null) {
            return;
        }
        if (!this.canActivate()) {
            return;
        }
        Predicate<ItemStack> canAccept = this::canAcceptItem;
        int count = this.getExtractionAmount();
        ItemHelper.ExtractionCountMode mode = this.getExtractionMode();
        if (mode == ItemHelper.ExtractionCountMode.UPTO || !ItemHelper.extract((IItemHandler)inv, canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)true).isEmpty()) {
            ItemHelper.extract((IItemHandler)inv, canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)false);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    protected IItemHandler grabCapability(@NotNull Direction side) {
        BlockPos pos = this.worldPosition.relative(side);
        if (this.level == null) {
            return null;
        }
        BlockEntity be = this.level.getBlockEntity(pos);
        if (be instanceof TrashCanBlockEntity && side != Direction.DOWN) {
            return null;
        }
        if (this.capCaches.get(side) == null) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                @Nullable BlockCapabilityCache cache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)pos, (Object)side.getOpposite());
                this.capCaches.put(side, (BlockCapabilityCache<IItemHandler, Direction>)cache);
                return (IItemHandler)cache.getCapability();
            }
            return (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side.getOpposite());
        }
        return (IItemHandler)this.capCaches.get(side).getCapability();
    }

    public void invalidate() {
        if (this.itemHandler != null) {
            this.invalidateCapabilities();
        }
        this.capCaches.clear();
        super.invalidate();
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return true;
    }
}

