/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.neoforge.client.events;

import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.flemmli97.tenshilib.client.ClientHandlers;
import io.github.flemmli97.tenshilib.client.CustomRiderRendererManager;
import io.github.flemmli97.tenshilib.client.TenshilibShaders;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import java.util.function.Consumer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

public class ClientEvents {
    public static void reloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)GeoAnimationManager.getInstance());
        event.registerReloadListener((PreparableReloadListener)CustomRiderRendererManager.getInstance());
        event.registerReloadListener((PreparableReloadListener)GeoModelManager.getInstance());
    }

    public static void clickSpecial(InputEvent.InteractionKeyMappingTriggered event) {
        boolean canceled;
        if (event.isAttack() && event.getHand() == InteractionHand.MAIN_HAND && (canceled = ClientHandlers.onClientClick())) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    public static void itemColors(RegisterColorHandlersEvent.Item event) {
        for (SpawnEgg egg : SpawnEgg.getEggs()) {
            event.register((stack, i) -> FastColor.ARGB32.opaque((int)egg.getColor(stack, i)), new ItemLike[]{egg});
        }
    }

    public static void onEntityRender(RenderLivingEvent.Pre<?, ?> event) {
        if (ClientHandlers.shouldDisableRender((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    public static void registerShader(RegisterShadersEvent event) {
        TenshilibShaders.registerShader((ResourceLocation id, VertexFormat vertexFormat, Consumer<ShaderInstance> onLoad) -> event.registerShader(new ShaderInstance(event.getResourceProvider(), id, vertexFormat), onLoad));
    }
}

