/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    public static boolean isItemBetter(LivingEntity holder, @Nullable LivingEntity target, ItemStack stack, ItemStack currentEquipped) {
        double d2;
        Item item;
        if (target == null) {
            Mob mob;
            LivingEntity livingEntity = target = holder instanceof Mob && (mob = (Mob)holder).getTarget() != null ? mob.getTarget() : holder;
        }
        if ((item = stack.getItem()) instanceof ArmorItem) {
            ArmorItem itemarmor = (ArmorItem)item;
            if (!(currentEquipped.getItem() instanceof ArmorItem) || EnchantmentHelper.has((ItemStack)currentEquipped, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
                return true;
            }
            Item item2 = currentEquipped.getItem();
            if (item2 instanceof ArmorItem) {
                ArmorItem itemarmor1 = (ArmorItem)item2;
                if (itemarmor.getDefense() == itemarmor1.getDefense()) {
                    return stack.getDamageValue() > currentEquipped.getDamageValue() || stack.getComponentsPatch().isEmpty() && !currentEquipped.getComponentsPatch().isEmpty();
                }
                return itemarmor.getDefense() > itemarmor1.getDefense();
            }
        }
        if (currentEquipped.isEmpty()) {
            return true;
        }
        double d1 = ItemUtils.damage(holder, target, stack);
        return d1 > (d2 = ItemUtils.damage(holder, target, currentEquipped));
    }

    public static double attribute(ItemAttributeModifiers modifiers, Holder<Attribute> attribute, double base, EquipmentSlotGroup ... groups) {
        AttributeInstance instance = new AttributeInstance(attribute, i -> {});
        instance.setBaseValue(base);
        if (modifiers != null) {
            for (EquipmentSlotGroup group : groups) {
                modifiers.forEach(group, (attr, mod) -> {
                    if (attr.is(attribute)) {
                        instance.addTransientModifier(mod);
                    }
                });
            }
        }
        return ((Attribute)attribute.value()).sanitizeValue(instance.getValue());
    }

    public static double attribute(ItemStack stack, Holder<Attribute> attribute, double base, EquipmentSlotGroup ... groups) {
        AttributeInstance instance = new AttributeInstance(attribute, i -> {});
        instance.setBaseValue(base);
        if (stack != null) {
            for (EquipmentSlotGroup group : groups) {
                stack.forEachModifier(group, (attr, mod) -> {
                    if (attr.is(attribute)) {
                        instance.addTransientModifier(mod);
                    }
                });
            }
        }
        return ((Attribute)attribute.value()).sanitizeValue(instance.getValue());
    }

    public static double damage(LivingEntity holder, @Nullable LivingEntity target, ItemStack stack) {
        double d;
        Level level;
        AttributeInstance attribute = holder.getAttribute(Attributes.ATTACK_DAMAGE);
        double dmg = ItemUtils.attribute(stack, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, attribute != null ? attribute.getValue() : 1.0, EquipmentSlotGroup.MAINHAND);
        DamageSource damageSource = holder.damageSources().mobAttack(holder);
        if (stack.getItem() instanceof BowItem) {
            damageSource = holder.damageSources().arrow((AbstractArrow)EntityType.ARROW.create(holder.level()), (Entity)holder);
        }
        if ((level = holder.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            d = (double)EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)holder.getWeaponItem(), (Entity)(target == null ? holder : target), (DamageSource)damageSource, (float)((float)dmg)) - dmg;
        } else {
            d = 0.0;
        }
        double bonus = d;
        return dmg + bonus;
    }

    public static boolean hasSpace(Player player, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Inventory inv = player.getInventory();
        stack = stack.copy();
        for (ItemStack invStack : inv.items) {
            if (invStack.isEmpty()) {
                stack.setCount(stack.getCount() - stack.getMaxStackSize());
            } else if (invStack.getCount() < invStack.getMaxStackSize() && ItemStack.matches((ItemStack)stack, (ItemStack)invStack)) {
                int sub = invStack.getMaxStackSize() - invStack.getCount();
                stack.setCount(stack.getCount() - sub);
            }
            if (stack.getCount() > 0) continue;
            break;
        }
        return stack.getCount() <= 0;
    }
}

