/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.tenshilib.common.entity.AOEAttackEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.memory.MoreMemoryModules;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class MoveToAttackTarget<E extends PathfinderMob & AnimatedEntity>
extends WalkOrRunToWalkTarget<E> {
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)4).hasMemories(new MemoryModuleType[]{(MemoryModuleType)MoreMemoryModules.ANIMATION_TO_PLAY.get()}).hasMemory(MemoryModuleType.WALK_TARGET).noMemory(MemoryModuleType.PATH).usesMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
    private boolean stopIfTouching;

    public MoveToAttackTarget<E> ignoreTouch(boolean ignoreTouch) {
        this.stopIfTouching = !ignoreTouch;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean doStartCheck(ServerLevel level, E entity, long gameTime) {
        AnimationPlayHolder animation = (AnimationPlayHolder)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MoreMemoryModules.ANIMATION_TO_PLAY.get()));
        return super.doStartCheck(level, entity, gameTime) && animation != null;
    }

    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        AnimationPlayHolder animation = (AnimationPlayHolder)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MoreMemoryModules.ANIMATION_TO_PLAY.get()));
        return super.canStillUse(level, entity, gameTime) && animation != null;
    }

    protected boolean hasReachedTarget(E entity, WalkTarget target) {
        AnimationPlayHolder animation = (AnimationPlayHolder)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MoreMemoryModules.ANIMATION_TO_PLAY.get()));
        if (animation == null) {
            return true;
        }
        PositionTracker positionTracker = target.getTarget();
        if (positionTracker instanceof EntityTracker) {
            EntityTracker entityTracker = (EntityTracker)positionTracker;
            Entity targetEntity = entityTracker.getEntity();
            OrientedBoundingBox aabb = ((AOEAttackEntity)entity).prepareAttackBox(animation.animation(), targetEntity, -0.15, target.getCloseEnoughDist() <= 1);
            if (aabb.intersects(targetEntity.getBoundingBox())) {
                return true;
            }
            if (this.stopIfTouching && entity.getBoundingBox().inflate(0.5).intersects(targetEntity.getBoundingBox())) {
                return true;
            }
        }
        return super.hasReachedTarget(entity, target);
    }
}

