/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.RepeatingBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.SequentialBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;

public class SelectableBehaviourBuilder<E extends LivingEntity> {
    private final List<Pair<ExtendedBehaviour<E>, Integer>> behaviors = new ArrayList<Pair<ExtendedBehaviour<E>, Integer>>();

    public static <E extends LivingEntity> SelectableBehaviourBuilder<E> builder() {
        return new SelectableBehaviourBuilder<E>();
    }

    @SafeVarargs
    public final SelectableBehaviourBuilder<E> add(int weight, ExtendedBehaviour<E> ... behaviours) {
        if (behaviours.length == 0) {
            return this;
        }
        if (behaviours.length == 1 && behaviours[0] instanceof Idle) {
            this.behaviors.add(Pair.of(behaviours[0], (Object)weight));
        } else {
            this.behaviors.add(Pair.of((Object)new RepeatingBehaviour((ExtendedBehaviour)new SequentialBehaviour(behaviours)), (Object)weight));
        }
        return this;
    }

    public SelectableBehaviourBuilder<E> addOpt(int weight, ExtendedBehaviour<E> behaviour) {
        this.behaviors.add(Pair.of((Object)new RepeatingBehaviour(behaviour), (Object)weight));
        return this;
    }

    public ExtendedBehaviour<E> build() {
        return new OneRandomBehaviour((Pair[])this.behaviors.toArray(Pair[]::new));
    }
}

