/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.data.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public abstract class CodecBasedProvider<T>
implements DataProvider {
    protected final PackOutput output;
    protected final PackOutput.Target target;
    protected final String name;
    protected final String modid;
    protected final String directory;
    protected final Codec<T> codec;
    protected final CompletableFuture<HolderLookup.Provider> provider;
    protected final Map<ResourceLocation, T> contents = new HashMap<ResourceLocation, T>();

    public CodecBasedProvider(PackOutput output, PackOutput.Target target, String modid, String directory, Codec<T> codec, CompletableFuture<HolderLookup.Provider> provider) {
        this(output, target, directory, modid, directory, codec, provider);
    }

    public CodecBasedProvider(PackOutput output, PackOutput.Target target, String name, String modid, String directory, Codec<T> codec, CompletableFuture<HolderLookup.Provider> provider) {
        this.output = output;
        this.target = target;
        this.name = name;
        this.modid = modid;
        this.directory = directory;
        this.codec = codec;
        this.provider = provider;
    }

    protected abstract void add(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput cache) {
        return ((CompletableFuture)this.provider.thenApply(provider -> {
            this.add((HolderLookup.Provider)provider);
            return provider;
        })).thenCompose(provider -> {
            RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider);
            return CompletableFuture.allOf((CompletableFuture[])this.contents.entrySet().stream().map(arg_0 -> this.lambda$run$3((DynamicOps)ops, cache, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    protected Path getPath(ResourceLocation id) {
        return this.output.getOutputFolder(this.target).resolve(id.getNamespace()).resolve(this.directory).resolve(id.getPath() + ".json");
    }

    protected JsonElement encode(DynamicOps<JsonElement> ops, T value) {
        return (JsonElement)this.codec.encodeStart(ops, value).getOrThrow();
    }

    public String getName() {
        return String.format("Provider %s for %s", this.name, this.modid);
    }

    private /* synthetic */ CompletableFuture lambda$run$3(DynamicOps ops, CachedOutput cache, Map.Entry entry) {
        return CompletableFuture.supplyAsync(() -> this.encode((DynamicOps<JsonElement>)ops, entry.getValue())).thenCompose(element -> DataProvider.saveStable((CachedOutput)cache, (JsonElement)element, (Path)this.getPath((ResourceLocation)entry.getKey())));
    }
}

