/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.particles;

import io.github.flemmli97.tenshilib.client.particles.ParticleRenderTypes;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class ColoredParticle
extends TextureSheetParticle {
    public final SpriteSet spriteProvider;
    protected boolean randomMovements;
    protected boolean gravity;
    protected int textureSizeX = 16;
    protected int textureSizeY = 16;

    public ColoredParticle(ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ, ColoredParticleData colorData, SpriteSet sprite, int maxAge, float minAgeRand, float maxAgeRand, boolean collide, boolean randomMovements, boolean gravity) {
        super(level, x, y, z);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.setColor(colorData.getRed(), colorData.getGreen(), colorData.getBlue());
        this.setAlpha(colorData.getAlpha());
        float mult = Mth.nextFloat((RandomSource)level.random, (float)minAgeRand, (float)maxAgeRand);
        this.lifetime = (int)((float)maxAge * mult);
        this.spriteProvider = sprite;
        this.setSpriteFromAge(this.spriteProvider);
        this.quadSize *= colorData.getScale();
        this.hasPhysics = collide;
        this.randomMovements = randomMovements;
        this.gravity = gravity;
    }

    public ColoredParticle setScale(float scale) {
        this.quadSize = scale;
        return this;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + partialTicks) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderTypes.TRANSLUCENTADD;
    }

    protected float getU0() {
        if (this.textureSizeX <= 0) {
            return super.getU0();
        }
        float u0 = super.getU0();
        float u1 = super.getU1();
        return u0 + (u1 - u0) * (1.0f / (float)this.textureSizeX);
    }

    protected float getU1() {
        if (this.textureSizeX <= 0) {
            return super.getU1();
        }
        float u0 = super.getU0();
        float u1 = super.getU1();
        return u1 - (u1 - u0) * (1.0f / (float)this.textureSizeX);
    }

    protected float getV0() {
        if (this.textureSizeY <= 0) {
            return super.getV0();
        }
        float v0 = super.getV0();
        float v1 = super.getV1();
        return v0 + (v1 - v0) * (1.0f / (float)this.textureSizeY);
    }

    protected float getV1() {
        if (this.textureSizeY <= 0) {
            return super.getV1();
        }
        float v0 = super.getV0();
        float v1 = super.getV1();
        return v1 - (v1 - v0) * (1.0f / (float)this.textureSizeY);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.spriteProvider);
            this.move(this.xd, this.yd, this.zd);
            if (this.randomMovements) {
                if (this.y == this.yo) {
                    this.xd *= 1.1;
                    this.zd *= 1.1;
                }
                this.xd *= (double)0.96f;
                this.yd *= (double)0.96f;
                this.zd *= (double)0.96f;
                if (this.onGround) {
                    this.xd *= (double)0.7f;
                    this.zd *= (double)0.7f;
                }
            }
            if (this.gravity) {
                this.yd = this.gravity();
                this.yd = Math.max(this.yd, (double)this.maxGravity());
            }
        }
    }

    protected float gravity() {
        return -0.009f;
    }

    protected float maxGravity() {
        return -0.1f;
    }

    public static class NoGravityParticleFactory
    implements ParticleProvider<ColoredParticleData> {
        private final SpriteSet sprite;

        public NoGravityParticleFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(ColoredParticleData data, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ColoredParticle(level, x, y, z, motionX, motionY, motionZ, data, this.sprite, 20, 1.0f, 1.0f, false, false, false).setScale(data.getScale());
        }
    }

    public static class LightParticleFactory
    implements ParticleProvider<ColoredParticleData> {
        private final SpriteSet sprite;

        public LightParticleFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(ColoredParticleData data, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ColoredParticle(level, x, y, z, motionX, motionY, motionZ, data, this.sprite, 40, 0.7f, 1.3f, false, true, false);
        }
    }
}

