/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.items;

import earth.terrarium.tempad.api.ActionType;
import earth.terrarium.tempad.api.context.ContextRegistry;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.api.tva_device.ChrononHandlerKt;
import earth.terrarium.tempad.common.items.CapacitorItem;
import earth.terrarium.tempad.common.registries.ModTags;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0016\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u001c"}, d2={"Learth/terrarium/tempad/common/items/ChronometerItem;", "Learth/terrarium/tempad/common/items/CapacitorItem;", "rate", "Lkotlin/Function0;", "", "amount", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getRate", "()Lkotlin/jvm/functions/Function0;", "getAmount", "inventoryTick", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "slot", "selected", "", "isChargable", "source", "target", "isClashing", "player", "Lnet/minecraft/world/entity/player/Player;", "tempad-1.21.1"})
public final class ChronometerItem
extends CapacitorItem {
    @NotNull
    private final Function0<Integer> rate;
    @NotNull
    private final Function0<Integer> amount;

    public ChronometerItem(@NotNull Function0<Integer> rate, @NotNull Function0<Integer> amount) {
        Intrinsics.checkNotNullParameter(rate, (String)"rate");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        this.rate = rate;
        this.amount = amount;
    }

    @NotNull
    public final Function0<Integer> getRate() {
        return this.rate;
    }

    @NotNull
    public final Function0<Integer> getAmount() {
        return this.amount;
    }

    @Override
    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                super.inventoryTick(stack, level, entity, slot, selected);
                if (level.isClientSide || !(entity instanceof Player) || entity.tickCount % ((Number)this.rate.invoke()).intValue() != 0 || this.isClashing((Player)entity, stack)) {
                    return;
                }
                ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(stack);
                if (chrononHandler != null) {
                    chrononHandler.insert(((Number)this.amount.invoke()).intValue(), ActionType.Execute);
                }
                if (ChrononHandlerKt.getChronons(stack) == null) break block3;
                this.distribute((Player)entity, stack);
                break block4;
            }
            SyncableContext<?> syncableContext = ContextRegistry.INSTANCE.locate((Player)entity, (Function1<? super ItemStack, Boolean>)((Function1)arg_0 -> ChronometerItem.inventoryTick$lambda$0(this, stack, arg_0)));
            if (syncableContext == null) break block4;
            SyncableContext<?> it = syncableContext;
            boolean bl = false;
            ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(it.getStack());
            if (chrononHandler != null) {
                chrononHandler.insert(((Number)this.amount.invoke()).intValue(), ActionType.Execute);
            }
        }
    }

    @Override
    public boolean isChargable(@NotNull ItemStack source, @NotNull ItemStack target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(target);
        return (chrononHandler != null ? ChrononHandlerKt.getHasRoom(chrononHandler) : false) && target != source && !ExtensionsKt.contains(ModTags.INSTANCE.getChargeBlacklist(), target);
    }

    public final boolean isClashing(@NotNull Player player, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return ContextRegistry.INSTANCE.locate(player, (Function1<? super ItemStack, Boolean>)((Function1)arg_0 -> ChronometerItem.isClashing$lambda$2(stack, arg_0))) != null;
    }

    private static final boolean inventoryTick$lambda$0(ChronometerItem this$0, ItemStack $stack, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isChargable($stack, it);
    }

    private static final boolean isClashing$lambda$2(ItemStack $stack, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ExtensionsKt.contains(ModTags.INSTANCE.getChrononGens(), it) && it != $stack;
    }
}

