/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.teamresourceful.resourcefullib.common.color.Color;
import earth.terrarium.tempad.Tempad;
import earth.terrarium.tempad.api.ActionType;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.api.event.TimedoorEvent;
import earth.terrarium.tempad.api.locations.NamedGlobalVec3;
import earth.terrarium.tempad.api.locations.NamedGlobalVec3Kt;
import earth.terrarium.tempad.api.sizing.DoorType;
import earth.terrarium.tempad.api.sizing.DynamicAngledPlacement;
import earth.terrarium.tempad.api.sizing.FloorPlacementSettings;
import earth.terrarium.tempad.api.sizing.TimedoorPlacementSettings;
import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.api.tva_device.ChrononHandlerKt;
import earth.terrarium.tempad.common.config.CommonConfig;
import earth.terrarium.tempad.common.network.s2c.RotatePlayerMomentumPacket;
import earth.terrarium.tempad.common.registries.ModAttachmentsKt;
import earth.terrarium.tempad.common.registries.ModEntities;
import earth.terrarium.tempad.common.registries.ModSounds;
import earth.terrarium.tempad.common.registries.ModTags;
import earth.terrarium.tempad.common.utils.DataDelegate;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 t2\u00020\u0001:\u0001tB\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010X\u001a\u0002052\u0006\u0010Y\u001a\u00020\u00012\u0006\u0010P\u001a\u00020\u0005H\u0002J\u0010\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]H\u0014J\u0010\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020_H\u0016J\u0010\u0010a\u001a\u00020[2\u0006\u0010`\u001a\u00020_H\u0016J\u0010\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0016J\b\u0010f\u001a\u000205H\u0016J\b\u0010g\u001a\u00020[H\u0016J\b\u0010h\u001a\u00020[H\u0002J\b\u0010i\u001a\u00020[H\u0002J\u0010\u0010j\u001a\u00020[2\u0006\u0010k\u001a\u00020lH\u0016J\u000e\u0010m\u001a\u00020[2\u0006\u0010n\u001a\u00020UJ\b\u0010o\u001a\u000205H\u0016J\u0010\u0010p\u001a\u00020[2\u0006\u0010q\u001a\u00020_H\u0014J\u0010\u0010r\u001a\u00020[2\u0006\u0010q\u001a\u00020_H\u0014J\b\u0010s\u001a\u00020[H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R+\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR7\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u001c\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R+\u0010%\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020$8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010\u001c\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R+\u0010+\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b.\u0010\u001c\u001a\u0004\b,\u0010\u000b\"\u0004\b-\u0010\rR\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R+\u00106\u001a\u0002052\u0006\u0010\u0014\u001a\u0002058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b;\u0010\u001c\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R+\u0010<\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b?\u0010\u001c\u001a\u0004\b=\u0010\u000b\"\u0004\b>\u0010\rR\u001c\u0010@\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u00102\"\u0004\bB\u00104R\u001a\u0010C\u001a\u000205X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u00108\"\u0004\bE\u0010:R$\u0010H\u001a\u00020G2\u0006\u0010F\u001a\u00020G8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u0013\u0010M\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u0016\u0010P\u001a\u0004\u0018\u00010Q8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u0014\u0010T\u001a\u00020U8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010W\u00a8\u0006u"}, d2={"Learth/terrarium/tempad/common/entity/TimedoorEntity;", "Lnet/minecraft/world/entity/Entity;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "beganClosing", "", "getBeganClosing", "()I", "setBeganClosing", "(I)V", "targetAngle", "", "getTargetAngle", "()F", "setTargetAngle", "(F)V", "<set-?>", "Lnet/minecraft/world/phys/Vec3;", "targetPos", "getTargetPos", "()Lnet/minecraft/world/phys/Vec3;", "setTargetPos", "(Lnet/minecraft/world/phys/Vec3;)V", "targetPos$delegate", "Learth/terrarium/tempad/common/utils/DataDelegate;", "Lnet/minecraft/resources/ResourceKey;", "targetDimension", "getTargetDimension", "()Lnet/minecraft/resources/ResourceKey;", "setTargetDimension", "(Lnet/minecraft/resources/ResourceKey;)V", "targetDimension$delegate", "Lcom/teamresourceful/resourcefullib/common/color/Color;", "color", "getColor", "()Lcom/teamresourceful/resourcefullib/common/color/Color;", "setColor", "(Lcom/teamresourceful/resourcefullib/common/color/Color;)V", "color$delegate", "closingTime", "getClosingTime", "setClosingTime", "closingTime$delegate", "owner", "Ljava/util/UUID;", "getOwner", "()Ljava/util/UUID;", "setOwner", "(Ljava/util/UUID;)V", "", "glitching", "getGlitching", "()Z", "setGlitching", "(Z)V", "glitching$delegate", "animationOffset", "getAnimationOffset", "setAnimationOffset", "animationOffset$delegate", "linkedPortalId", "getLinkedPortalId", "setLinkedPortalId", "original", "getOriginal", "setOriginal", "value", "Learth/terrarium/tempad/api/sizing/TimedoorPlacementSettings;", "sizing", "getSizing", "()Learth/terrarium/tempad/api/sizing/TimedoorPlacementSettings;", "setSizing", "(Learth/terrarium/tempad/api/sizing/TimedoorPlacementSettings;)V", "linkedPortalEntity", "getLinkedPortalEntity", "()Learth/terrarium/tempad/common/entity/TimedoorEntity;", "targetLevel", "Lnet/minecraft/server/level/ServerLevel;", "getTargetLevel", "()Lnet/minecraft/server/level/ServerLevel;", "selfLocation", "Learth/terrarium/tempad/api/locations/NamedGlobalVec3;", "getSelfLocation", "()Learth/terrarium/tempad/api/locations/NamedGlobalVec3;", "canTeleport", "entity", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "saveWithoutId", "Lnet/minecraft/nbt/CompoundTag;", "compound", "load", "getDimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "pose", "Lnet/minecraft/world/entity/Pose;", "isAlwaysTicking", "tick", "tryInitReceivingPortal", "tryClose", "remove", "reason", "Lnet/minecraft/world/entity/Entity$RemovalReason;", "setLocation", "location", "fireImmune", "readAdditionalSaveData", "pCompound", "addAdditionalSaveData", "onAddedToLevel", "Companion", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nTimedoorEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimedoorEntity.kt\nearth/terrarium/tempad/common/entity/TimedoorEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\nearth/terrarium/tempad/common/utils/ExtensionsKt\n+ 4 DelegateUtils.kt\nearth/terrarium/tempad/common/utils/DelegateUtilsKt\n*L\n1#1,400:1\n1#2:401\n120#3:402\n153#4:403\n153#4:404\n153#4:405\n153#4:406\n153#4:407\n153#4:408\n153#4:409\n*S KotlinDebug\n*F\n+ 1 TimedoorEntity.kt\nearth/terrarium/tempad/common/entity/TimedoorEntity\n*L\n302#1:402\n51#1:403\n52#1:404\n53#1:405\n55#1:406\n56#1:407\n57#1:408\n58#1:409\n*E\n"})
public final class TimedoorEntity
extends Entity {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private int beganClosing;
    private float targetAngle;
    @NotNull
    private final DataDelegate targetPos$delegate;
    @NotNull
    private final DataDelegate targetDimension$delegate;
    @NotNull
    private final DataDelegate color$delegate;
    @NotNull
    private final DataDelegate closingTime$delegate;
    @Nullable
    private UUID owner;
    @NotNull
    private final DataDelegate glitching$delegate;
    @NotNull
    private final DataDelegate animationOffset$delegate;
    @Nullable
    private UUID linkedPortalId;
    private boolean original;
    public static final int IDLE_BEFORE_START = 26;
    public static final int ANIMATION_LENGTH = 5;
    @NotNull
    private static final EntityDataAccessor<Integer> closingTimeAccessor;
    @NotNull
    private static final EntityDataAccessor<Color> colorAccessor;
    @NotNull
    private static final EntityDataAccessor<Vec3> targetPosAccessor;
    @NotNull
    private static final EntityDataAccessor<ResourceKey<Level>> targetDimAccessor;
    @NotNull
    private static final EntityDataAccessor<TimedoorPlacementSettings> sizingAccessor;
    @NotNull
    private static final EntityDataAccessor<Boolean> glitchingAccessor;
    @NotNull
    private static final EntityDataAccessor<Integer> offsetAccessor;
    private static final MutableComponent fail;
    private static final MutableComponent posFail;
    private static final MutableComponent interDimFail;
    private static final MutableComponent intraDimAllFail;
    private static final MutableComponent intraDimFail;
    private static final MutableComponent enteringFail;
    private static final MutableComponent leavingFail;
    private static final MutableComponent noChrononsFail;

    public TimedoorEntity(@NotNull EntityType<?> type2, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type2, level);
        this.targetPos$delegate = new DataDelegate<Vec3>(targetPosAccessor);
        this.targetDimension$delegate = new DataDelegate<ResourceKey<Level>>(targetDimAccessor);
        this.color$delegate = new DataDelegate<Color>(colorAccessor);
        this.closingTime$delegate = new DataDelegate<Integer>(closingTimeAccessor);
        this.glitching$delegate = new DataDelegate<Boolean>(glitchingAccessor);
        this.animationOffset$delegate = new DataDelegate<Integer>(offsetAccessor);
        this.original = true;
    }

    public final int getBeganClosing() {
        return this.beganClosing;
    }

    public final void setBeganClosing(int n) {
        this.beganClosing = n;
    }

    public final float getTargetAngle() {
        return this.targetAngle;
    }

    public final void setTargetAngle(float f) {
        this.targetAngle = f;
    }

    @NotNull
    public final Vec3 getTargetPos() {
        return (Vec3)this.targetPos$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setTargetPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.targetPos$delegate.setValue(this, $$delegatedProperties[0], vec3);
    }

    @NotNull
    public final ResourceKey<Level> getTargetDimension() {
        return (ResourceKey)this.targetDimension$delegate.getValue(this, $$delegatedProperties[1]);
    }

    public final void setTargetDimension(@NotNull ResourceKey<Level> resourceKey) {
        Intrinsics.checkNotNullParameter(resourceKey, (String)"<set-?>");
        this.targetDimension$delegate.setValue(this, $$delegatedProperties[1], resourceKey);
    }

    @NotNull
    public final Color getColor() {
        return (Color)this.color$delegate.getValue(this, $$delegatedProperties[2]);
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.color$delegate.setValue(this, $$delegatedProperties[2], color);
    }

    public final int getClosingTime() {
        return ((Number)this.closingTime$delegate.getValue(this, $$delegatedProperties[3])).intValue();
    }

    public final void setClosingTime(int n) {
        this.closingTime$delegate.setValue(this, $$delegatedProperties[3], n);
    }

    @Nullable
    public final UUID getOwner() {
        return this.owner;
    }

    public final void setOwner(@Nullable UUID uUID) {
        this.owner = uUID;
    }

    public final boolean getGlitching() {
        return (Boolean)this.glitching$delegate.getValue(this, $$delegatedProperties[4]);
    }

    public final void setGlitching(boolean bl) {
        this.glitching$delegate.setValue(this, $$delegatedProperties[4], bl);
    }

    public final int getAnimationOffset() {
        return ((Number)this.animationOffset$delegate.getValue(this, $$delegatedProperties[5])).intValue();
    }

    public final void setAnimationOffset(int n) {
        this.animationOffset$delegate.setValue(this, $$delegatedProperties[5], n);
    }

    @Nullable
    public final UUID getLinkedPortalId() {
        return this.linkedPortalId;
    }

    public final void setLinkedPortalId(@Nullable UUID uUID) {
        this.linkedPortalId = uUID;
    }

    public final boolean getOriginal() {
        return this.original;
    }

    public final void setOriginal(boolean bl) {
        this.original = bl;
    }

    @NotNull
    public final TimedoorPlacementSettings getSizing() {
        Object object = this.entityData.get(sizingAccessor);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (TimedoorPlacementSettings)object;
    }

    public final void setSizing(@NotNull TimedoorPlacementSettings value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.entityData.set(sizingAccessor, (Object)value);
        this.fixupDimensions();
    }

    @Nullable
    public final TimedoorEntity getLinkedPortalEntity() {
        Entity entity;
        UUID uUID = this.linkedPortalId;
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            ServerLevel serverLevel = this.getTargetLevel();
            entity = serverLevel != null && (serverLevel = serverLevel.getEntities()) != null ? (Entity)serverLevel.get(it) : null;
        } else {
            entity = null;
        }
        Entity entity2 = entity;
        return entity2 instanceof TimedoorEntity ? (TimedoorEntity)entity2 : null;
    }

    private final ServerLevel getTargetLevel() {
        ResourceKey<Level> it = this.getTargetDimension();
        boolean bl = false;
        return ExtensionsKt.get(this.level().getServer(), it);
    }

    private final NamedGlobalVec3 getSelfLocation() {
        Component component = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        Vec3 vec3 = NamedGlobalVec3Kt.offsetLocation$default(ExtensionsKt.getPos(this), this.getYRot(), 0, 4, null);
        ResourceKey resourceKey = this.level().dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        return new NamedGlobalVec3(component, vec3, (ResourceKey<Level>)resourceKey, this.getYRot(), this.getColor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canTeleport(Entity entity, Level targetLevel) {
        TimedoorPlacementSettings $this$canTeleport_u24lambda_u243 = this.getSizing();
        boolean bl = false;
        if (entity instanceof TimedoorEntity) return false;
        if (!$this$canTeleport_u24lambda_u243.isInside(this, entity)) return false;
        if (ExtensionsKt.contains(ModTags.INSTANCE.getTeleportingNotSupport(), entity)) return false;
        if (!entity.canChangeDimensions(this.level(), targetLevel)) return false;
        if (entity.isPassenger()) return false;
        Integer n = ModAttachmentsKt.getAgeUntilAllowedThroughTimedoor((AttachmentHolder)entity);
        if (n == null) return true;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        if (entity.tickCount <= it) return false;
        return true;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(closingTimeAccessor, (Object)CommonConfig.TimeDoor.timeInWorld);
        builder.define(colorAccessor, (Object)Tempad.Companion.getORANGE());
        builder.define(targetPosAccessor, (Object)Vec3.ZERO);
        builder.define(targetDimAccessor, (Object)Level.OVERWORLD);
        builder.define(sizingAccessor, (Object)new DynamicAngledPlacement());
        builder.define(glitchingAccessor, (Object)false);
        builder.define(offsetAccessor, (Object)0);
    }

    @NotNull
    public CompoundTag saveWithoutId(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        CompoundTag tag = super.saveWithoutId(compound);
        tag.putInt("Age", this.tickCount);
        tag.putInt("ClosingTime", this.getClosingTime());
        tag.putFloat("TargetAngle", this.targetAngle);
        tag.putBoolean("IsGlitching", this.getGlitching());
        tag.putBoolean("IsOriginal", this.original);
        tag.putString("LinkedPortalId", String.valueOf(this.linkedPortalId));
        Intrinsics.checkNotNull((Object)tag);
        Codec codec2 = Color.CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"CODEC");
        ExtensionsKt.save(tag, codec2, "Color", this.getColor());
        Codec codec3 = Vec3.CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec3, (String)"CODEC");
        ExtensionsKt.save(tag, codec3, "TargetPos", this.getTargetPos());
        Codec codec4 = ResourceKey.codec((ResourceKey)Registries.DIMENSION);
        Intrinsics.checkNotNullExpressionValue((Object)codec4, (String)"codec(...)");
        ExtensionsKt.save(tag, codec4, "TargetDimension", this.getTargetDimension());
        ExtensionsKt.save(tag, TimedoorPlacementSettings.Companion.getCodec(), "PlacementSettings", this.getSizing());
        return tag;
    }

    public void load(@NotNull CompoundTag compound) {
        block5: {
            UUID uUID;
            Object it;
            String string;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            super.load(compound);
            this.tickCount = compound.getInt("Age");
            this.setClosingTime(compound.getInt("ClosingTime"));
            this.targetAngle = compound.getFloat("TargetAngle");
            this.setGlitching(compound.getBoolean("IsGlitching"));
            this.original = compound.getBoolean("IsOriginal");
            String string2 = string = compound.getString("LinkedPortalId");
            TimedoorEntity timedoorEntity = this;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            boolean bl2 = StringsKt.isBlank((CharSequence)((CharSequence)it));
            TimedoorEntity timedoorEntity2 = timedoorEntity;
            String string3 = !bl2 ? string : null;
            if (string3 != null) {
                it = string3;
                timedoorEntity = timedoorEntity2;
                boolean bl3 = false;
                uUID = UUID.fromString((String)it);
                timedoorEntity2 = timedoorEntity;
            } else {
                uUID = null;
            }
            timedoorEntity2.linkedPortalId = uUID;
            Codec codec2 = Color.CODEC;
            Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"CODEC");
            Color color = (Color)ExtensionsKt.load(compound, codec2, "Color");
            if (color != null) {
                it = color;
                boolean bl4 = false;
                this.setColor((Color)it);
            }
            Codec codec3 = Vec3.CODEC;
            Intrinsics.checkNotNullExpressionValue((Object)codec3, (String)"CODEC");
            Vec3 vec3 = (Vec3)ExtensionsKt.load(compound, codec3, "TargetPos");
            if (vec3 != null) {
                it = vec3;
                boolean bl5 = false;
                this.setTargetPos((Vec3)it);
            }
            Codec codec4 = ResourceKey.codec((ResourceKey)Registries.DIMENSION);
            Intrinsics.checkNotNullExpressionValue((Object)codec4, (String)"codec(...)");
            ResourceKey resourceKey = (ResourceKey)ExtensionsKt.load(compound, codec4, "TargetDimension");
            if (resourceKey != null) {
                it = resourceKey;
                boolean bl6 = false;
                this.setTargetDimension((ResourceKey<Level>)it);
            }
            TimedoorPlacementSettings timedoorPlacementSettings = ExtensionsKt.load(compound, TimedoorPlacementSettings.Companion.getCodec(), "PlacementSettings");
            if (timedoorPlacementSettings == null) break block5;
            it = timedoorPlacementSettings;
            boolean bl7 = false;
            this.setSizing((TimedoorPlacementSettings)it);
        }
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        return this.getSizing().getDimensions();
    }

    public boolean isAlwaysTicking() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        void area$iv;
        void $this$getEntities$iv;
        super.tick();
        if (this.level().isClientSide()) {
            if (!(this.getSizing().getDimensions().width() == this.getBbWidth()) || !(this.getSizing().getDimensions().height() == this.getBbHeight())) {
                this.fixupDimensions();
                this.setBoundingBox(this.makeBoundingBox());
            }
            double percent = (double)this.tickCount / 26.0;
            if (this.tickCount < 26 && this.random.nextDouble() < percent) {
                double y = this.getY() + (double)this.getBbHeight() / 2.0;
                this.level().addParticle((ParticleOptions)new DustParticleOptions(ExtensionsKt.getVec3f(this.getColor()), 1.0f), true, this.getX() + this.random.nextDouble() * (percent *= 0.25) - percent / (double)2, y + this.random.nextDouble() * percent - percent / (double)2, this.getZ() + this.random.nextDouble() * percent - percent / (double)2, 0.0, 0.0, 0.0);
            }
            return;
        }
        int percent = this.getClosingTime();
        this.setClosingTime(percent + -1);
        this.tryClose();
        if (this.tickCount < 31 || this.getClosingTime() < 5) {
            return;
        }
        ServerLevel serverLevel = this.getTargetLevel();
        if (serverLevel == null) {
            return;
        }
        ServerLevel targetLevel = serverLevel;
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        EntityGetter y = (EntityGetter)level;
        AABB aABB = this.getBoundingBox();
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"getBoundingBox(...)");
        AABB aABB2 = aABB;
        Function1 predicate$iv = arg_0 -> TimedoorEntity.tick$lambda$10(this, targetLevel, arg_0);
        boolean $i$f$getEntities = false;
        Function1 function1 = predicate$iv;
        List list = $this$getEntities$iv.getEntitiesOfClass(Entity.class, (AABB)area$iv, new Predicate(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean test(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        List entities = list;
        if (!((Collection)entities).isEmpty()) {
            this.tryInitReceivingPortal();
            BlockPos pos = BlockPos.containing((Position)((Position)this.getTargetPos()));
            targetLevel.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkPos(pos), 3, (Object)pos);
        }
        for (Entity entity : entities) {
            Object it;
            TimedoorEvent.Enter event = (TimedoorEvent.Enter)ExtensionsKt.post((Event)new TimedoorEvent.Enter(this, entity));
            if (event.isCanceled()) continue;
            if ((entity instanceof ServerPlayer ? (ServerPlayer)entity : null) != null) {
                it = it;
                boolean bl = false;
                ((ServerPlayer)entity).connection.send((Packet)new ClientboundSoundEntityPacket(Holder.direct((Object)ModSounds.INSTANCE.getTimedoorEnterMono()), this.getSoundSource(), (Entity)this, 1.0f, 1.0f, 0L));
                this.level().playSound((Player)it, (Entity)this, ModSounds.INSTANCE.getTimedoorEnterStereo(), this.getSoundSource(), 1.0f, 1.0f);
            }
            if (Intrinsics.areEqual((Object)entity.level().dimension(), (Object)targetLevel.dimension())) {
                entity.setDeltaMovement(entity.getDeltaMovement().yRot(this.getYRot() - this.targetAngle));
                entity.teleportTo(targetLevel, this.getTargetPos().x, this.getTargetPos().y, this.getTargetPos().z, RelativeMovement.ALL, this.targetAngle, entity.getXRot());
                entity.hasImpulse = true;
                if (entity instanceof Player) {
                    ExtensionsKt.sendToClient((com.teamresourceful.resourcefullib.common.network.Packet)new RotatePlayerMomentumPacket(this.getYRot() - this.targetAngle), (Player)entity);
                }
                ModAttachmentsKt.setAgeUntilAllowedThroughTimedoor((AttachmentHolder)entity, entity.tickCount + 30);
            } else {
                entity.changeDimension(new DimensionTransition(targetLevel, this.getTargetPos(), entity.getDeltaMovement(), this.targetAngle, 0.0f, false, DimensionTransition.DO_NOTHING));
                ModAttachmentsKt.setAgeUntilAllowedThroughTimedoor((AttachmentHolder)entity, entity.tickCount + 60);
            }
            if (this.getLinkedPortalEntity() == null) continue;
            boolean bl = false;
            TimedoorEvent.Exit cfr_ignored_0 = (TimedoorEvent.Exit)ExtensionsKt.post((Event)new TimedoorEvent.Exit((TimedoorEntity)((Object)it), entity));
        }
    }

    private final void tryInitReceivingPortal() {
        if (this.getClosingTime() <= 0 && this.getClosingTime() != -1 || !this.original) {
            return;
        }
        ServerLevel serverLevel = this.getTargetLevel();
        if (serverLevel == null) {
            return;
        }
        ServerLevel targetLevel = serverLevel;
        TimedoorEntity timedoorEntity = this.getLinkedPortalEntity();
        if (timedoorEntity != null) {
            TimedoorEntity it = timedoorEntity;
            boolean bl = false;
            return;
        }
        TimedoorEntity targetPortal = new TimedoorEntity(ModEntities.INSTANCE.getTimedoor(), (Level)targetLevel);
        targetPortal.linkedPortalId = this.uuid;
        targetPortal.setClosingTime(this.getClosingTime());
        targetPortal.setLocation(this.getSelfLocation());
        targetPortal.setSizing(this.getSizing());
        targetPortal.setGlitching(this.getGlitching());
        targetPortal.original = false;
        this.getSizing().placeTimedoor(DoorType.EXIT, this.getTargetPos(), this.targetAngle + 180.0f, targetPortal);
        this.linkedPortalId = targetPortal.uuid;
        targetLevel.addFreshEntity((Entity)targetPortal);
    }

    private final void tryClose() {
        if (this.getClosingTime() <= 0 && this.getClosingTime() != -1) {
            ExtensionsKt.post((Event)new TimedoorEvent.Close(this));
            if (this.getLinkedPortalEntity() != null) {
                this.getLinkedPortalEntity().linkedPortalId = null;
            }
            this.discard();
        }
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super.remove(reason);
            if (!this.original) break block1;
            TimedoorEntity timedoorEntity = this.getLinkedPortalEntity();
            if (timedoorEntity != null) {
                timedoorEntity.remove(reason);
            }
        }
    }

    public final void setLocation(@NotNull NamedGlobalVec3 location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.setTargetPos(location.getPos());
        this.setTargetDimension(location.getDimension());
        this.setCustomName(location.getName());
        this.targetAngle = location.getAngle();
        this.setColor(location.getColor());
    }

    public boolean fireImmune() {
        return true;
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        Intrinsics.checkNotNullParameter((Object)pCompound, (String)"pCompound");
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        Intrinsics.checkNotNullParameter((Object)pCompound, (String)"pCompound");
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.level().isClientSide) {
            return;
        }
        this.level().playSound(null, this.blockPosition(), ModSounds.INSTANCE.getTimedoorOpen(), this.getSoundSource(), 1.0f, 1.0f);
    }

    private static final boolean tick$lambda$10(TimedoorEntity this$0, ServerLevel $targetLevel, Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.canTeleport(it, (Level)$targetLevel);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TimedoorEntity.class, "targetPos", "getTargetPos()Lnet/minecraft/world/phys/Vec3;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TimedoorEntity.class, "targetDimension", "getTargetDimension()Lnet/minecraft/resources/ResourceKey;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TimedoorEntity.class, "color", "getColor()Lcom/teamresourceful/resourcefullib/common/color/Color;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TimedoorEntity.class, "closingTime", "getClosingTime()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TimedoorEntity.class, "glitching", "getGlitching()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TimedoorEntity.class, "animationOffset", "getAnimationOffset()I", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        EntityDataSerializer<Color> entityDataSerializer = EntityDataSerializers.INT;
        Intrinsics.checkNotNullExpressionValue((Object)entityDataSerializer, (String)"INT");
        EntityDataSerializer serializer$iv = entityDataSerializer;
        boolean $i$f$createDataKey = false;
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(TimedoorEntity.class, (EntityDataSerializer)serializer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        closingTimeAccessor = entityDataAccessor;
        EntityDataSerializer<Color> entityDataSerializer2 = ModEntities.INSTANCE.getColorSerializer();
        Intrinsics.checkNotNullExpressionValue(entityDataSerializer2, (String)"<get-colorSerializer>(...)");
        serializer$iv = entityDataSerializer2;
        $i$f$createDataKey = false;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(TimedoorEntity.class, serializer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        colorAccessor = entityDataAccessor2;
        EntityDataSerializer<Vec3> entityDataSerializer3 = ModEntities.INSTANCE.getVec3Serializer();
        Intrinsics.checkNotNullExpressionValue(entityDataSerializer3, (String)"<get-vec3Serializer>(...)");
        serializer$iv = entityDataSerializer3;
        $i$f$createDataKey = false;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(TimedoorEntity.class, serializer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        targetPosAccessor = entityDataAccessor3;
        EntityDataSerializer<ResourceKey<Level>> entityDataSerializer4 = ModEntities.INSTANCE.getDimensionKeySerializer();
        Intrinsics.checkNotNullExpressionValue(entityDataSerializer4, (String)"<get-dimensionKeySerializer>(...)");
        serializer$iv = entityDataSerializer4;
        $i$f$createDataKey = false;
        EntityDataAccessor entityDataAccessor4 = SynchedEntityData.defineId(TimedoorEntity.class, serializer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor4, (String)"defineId(...)");
        targetDimAccessor = entityDataAccessor4;
        EntityDataSerializer<TimedoorPlacementSettings> entityDataSerializer5 = ModEntities.INSTANCE.getSizingSerializer();
        Intrinsics.checkNotNullExpressionValue(entityDataSerializer5, (String)"<get-sizingSerializer>(...)");
        serializer$iv = entityDataSerializer5;
        $i$f$createDataKey = false;
        EntityDataAccessor entityDataAccessor5 = SynchedEntityData.defineId(TimedoorEntity.class, serializer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor5, (String)"defineId(...)");
        sizingAccessor = entityDataAccessor5;
        EntityDataSerializer entityDataSerializer6 = EntityDataSerializers.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue((Object)entityDataSerializer6, (String)"BOOLEAN");
        serializer$iv = entityDataSerializer6;
        $i$f$createDataKey = false;
        EntityDataAccessor entityDataAccessor6 = SynchedEntityData.defineId(TimedoorEntity.class, (EntityDataSerializer)serializer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor6, (String)"defineId(...)");
        glitchingAccessor = entityDataAccessor6;
        EntityDataSerializer entityDataSerializer7 = EntityDataSerializers.INT;
        Intrinsics.checkNotNullExpressionValue((Object)entityDataSerializer7, (String)"INT");
        serializer$iv = entityDataSerializer7;
        $i$f$createDataKey = false;
        EntityDataAccessor entityDataAccessor7 = SynchedEntityData.defineId(TimedoorEntity.class, (EntityDataSerializer)serializer$iv);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor7, (String)"defineId(...)");
        offsetAccessor = entityDataAccessor7;
        fail = Component.translatable((String)"entity.tempad.timedoor.fail");
        posFail = Component.translatable((String)"entity.tempad.timedoor.fail.pos");
        interDimFail = Component.translatable((String)"entity.tempad.timedoor.fail.interdimensional");
        intraDimAllFail = Component.translatable((String)"entity.tempad.timedoor.fail.interdimensional_all");
        intraDimFail = Component.translatable((String)"entity.tempad.timedoor.fail.interdimensional");
        enteringFail = Component.translatable((String)"entity.tempad.timedoor.fail.entering");
        leavingFail = Component.translatable((String)"entity.tempad.timedoor.fail.leaving");
        noChrononsFail = Component.translatable((String)"entity.tempad.timedoor.fail.no_chronons");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u0002042\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020806JT\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u0002092\u0006\u0010:\u001a\u00020;2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u0002042\b\b\u0002\u0010<\u001a\u00020\u00112\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020806J,\u0010=\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020*0>2\u0006\u0010?\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\b\b\u0002\u0010@\u001a\u00020\u0013J \u0010A\u001a\u0002082\u0006\u0010+\u001a\u00020B2\u0006\u00103\u001a\u0002042\u0006\u0010C\u001a\u000207H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001b\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u001c\u0010\u0019R\u001b\u0010\u001d\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u001e\u0010\u0019R\u001b\u0010\u001f\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b \u0010\u0019R\u001b\u0010!\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\"\u0010\u0019R\u001b\u0010#\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b$\u0010\u0019R\u001b\u0010%\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b&\u0010\u0019R\u001b\u0010'\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b(\u0010\u0019\u00a8\u0006D"}, d2={"Learth/terrarium/tempad/common/entity/TimedoorEntity$Companion;", "", "<init>", "()V", "IDLE_BEFORE_START", "", "ANIMATION_LENGTH", "closingTimeAccessor", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "colorAccessor", "Lcom/teamresourceful/resourcefullib/common/color/Color;", "targetPosAccessor", "Lnet/minecraft/world/phys/Vec3;", "targetDimAccessor", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "sizingAccessor", "Learth/terrarium/tempad/api/sizing/TimedoorPlacementSettings;", "glitchingAccessor", "", "offsetAccessor", "fail", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "getFail", "()Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/network/chat/MutableComponent;", "posFail", "getPosFail", "interDimFail", "getInterDimFail", "intraDimAllFail", "getIntraDimAllFail", "intraDimFail", "getIntraDimFail", "enteringFail", "getEnteringFail", "leavingFail", "getLeavingFail", "noChrononsFail", "getNoChrononsFail", "openTimedoor", "Lnet/minecraft/network/chat/Component;", "player", "Lnet/minecraft/world/entity/player/Player;", "ctx", "Learth/terrarium/tempad/api/context/SyncableContext;", "provider", "Lnet/minecraft/resources/ResourceLocation;", "locationId", "Ljava/util/UUID;", "location", "Learth/terrarium/tempad/api/locations/NamedGlobalVec3;", "onOpen", "Lkotlin/Function1;", "Learth/terrarium/tempad/common/entity/TimedoorEntity;", "", "Lcom/mojang/authlib/GameProfile;", "block", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "sizing", "getTimedoor", "Lcom/mojang/datafixers/util/Either;", "level", "ignoreRestrictions", "logTimedoorOpen", "", "timedoor", "tempad-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nTimedoorEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimedoorEntity.kt\nearth/terrarium/tempad/common/entity/TimedoorEntity$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1#2:401\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final MutableComponent getFail() {
            return fail;
        }

        public final MutableComponent getPosFail() {
            return posFail;
        }

        public final MutableComponent getInterDimFail() {
            return interDimFail;
        }

        public final MutableComponent getIntraDimAllFail() {
            return intraDimAllFail;
        }

        public final MutableComponent getIntraDimFail() {
            return intraDimFail;
        }

        public final MutableComponent getEnteringFail() {
            return enteringFail;
        }

        public final MutableComponent getLeavingFail() {
            return leavingFail;
        }

        public final MutableComponent getNoChrononsFail() {
            return noChrononsFail;
        }

        @Nullable
        public final Component openTimedoor(@NotNull Player player, @NotNull SyncableContext<?> ctx2, @Nullable ResourceLocation provider, @Nullable UUID locationId, @NotNull NamedGlobalVec3 location, @NotNull Function1<? super TimedoorEntity, Unit> onOpen) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter(onOpen, (String)"onOpen");
            ItemStack stack = ctx2.getStack();
            if (!player.isCreative()) {
                ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(stack);
                if ((chrononHandler != null ? chrononHandler.extract(CommonConfig.TimeDoor.costPerDoor, ActionType.Simulate) : 0) < CommonConfig.TimeDoor.costPerDoor) {
                    return (Component)this.getNoChrononsFail();
                }
            }
            Level level = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            Either result = earth.terrarium.tempad.common.entity.TimedoorEntity$Companion.getTimedoor$default(this, level, location, false, 4, null);
            Optional optional = result.right();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"right(...)");
            Component component = (Component)OptionalsKt.getOrNull((Optional)optional);
            if (component != null) {
                Component it = component;
                boolean bl = false;
                return it;
            }
            Optional optional2 = result.left();
            Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"left(...)");
            TimedoorEntity timedoorEntity = (TimedoorEntity)((Object)OptionalsKt.getOrNull((Optional)optional2));
            if (timedoorEntity == null) {
                return (Component)this.getFail();
            }
            TimedoorEntity timedoor = timedoorEntity;
            timedoor.setOwner(player.getUUID());
            timedoor.setSizing(player.getXRot() > 45.0f ? (TimedoorPlacementSettings)new FloorPlacementSettings() : (TimedoorPlacementSettings)new DynamicAngledPlacement());
            TimedoorPlacementSettings timedoorPlacementSettings = timedoor.getSizing();
            Vec3 vec3 = player.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            timedoorPlacementSettings.placeTimedoor(DoorType.ENTRY, vec3, player.getYRot(), timedoor);
            GameProfile gameProfile = player.getGameProfile();
            Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"getGameProfile(...)");
            TimedoorEvent.OpenWithItem event = (TimedoorEvent.OpenWithItem)ExtensionsKt.post((Event)new TimedoorEvent.OpenWithItem(timedoor, gameProfile, ctx2, provider, locationId));
            if (event.isCanceled()) {
                Component component2 = event.getErrorMessage();
                if (component2 == null) {
                    component2 = (Component)this.getFail();
                }
                return component2;
            }
            String string = player.getName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.logTimedoorOpen(string, location, timedoor);
            if (!player.isCreative()) {
                ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(stack);
                if (chrononHandler != null) {
                    chrononHandler.extract(CommonConfig.TimeDoor.costPerDoor, ActionType.Execute);
                }
                player.getCooldowns().addCooldown(stack.getItem(), 40);
            }
            player.level().addFreshEntity((Entity)timedoor);
            onOpen.invoke((Object)timedoor);
            timedoor.tryInitReceivingPortal();
            return null;
        }

        public static /* synthetic */ Component openTimedoor$default(Companion companion, Player player, SyncableContext syncableContext, ResourceLocation resourceLocation, UUID uUID, NamedGlobalVec3 namedGlobalVec3, Function1 function1, int n, Object object) {
            if ((n & 0x20) != 0) {
                function1 = Companion::openTimedoor$lambda$0;
            }
            return companion.openTimedoor(player, syncableContext, resourceLocation, uUID, namedGlobalVec3, (Function1<? super TimedoorEntity, Unit>)function1);
        }

        @Nullable
        public final Component openTimedoor(@NotNull GameProfile player, @NotNull BlockEntity block, @Nullable ResourceLocation provider, @Nullable UUID locationId, @NotNull NamedGlobalVec3 location, @NotNull TimedoorPlacementSettings sizing, @NotNull Function1<? super TimedoorEntity, Unit> onOpen) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)sizing, (String)"sizing");
            Intrinsics.checkNotNullParameter(onOpen, (String)"onOpen");
            ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(block);
            if ((chrononHandler != null ? chrononHandler.extract(CommonConfig.TimeDoor.costPerDoor, ActionType.Simulate) : 0) < CommonConfig.TimeDoor.costPerDoor) {
                return (Component)this.getNoChrononsFail();
            }
            Level level = block.getLevel();
            Intrinsics.checkNotNull((Object)level);
            Either result = earth.terrarium.tempad.common.entity.TimedoorEntity$Companion.getTimedoor$default(this, level, location, false, 4, null);
            Optional optional = result.right();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"right(...)");
            Component component = (Component)OptionalsKt.getOrNull((Optional)optional);
            if (component != null) {
                Component it = component;
                boolean bl = false;
                return it;
            }
            Optional optional2 = result.left();
            Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"left(...)");
            TimedoorEntity timedoorEntity = (TimedoorEntity)((Object)OptionalsKt.getOrNull((Optional)optional2));
            if (timedoorEntity == null) {
                return (Component)this.getFail();
            }
            TimedoorEntity timedoor = timedoorEntity;
            timedoor.setOwner(player.getId());
            timedoor.setSizing(sizing);
            TimedoorPlacementSettings timedoorPlacementSettings = timedoor.getSizing();
            Vec3 vec3 = Vec3.atCenterOf((Vec3i)((Vec3i)block.getBlockPos())).add(0.0, -1.5, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            timedoorPlacementSettings.placeTimedoor(DoorType.ENTRY, vec3, ((Direction)block.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + (float)180, timedoor);
            TimedoorEvent.OpenWithBlock event = (TimedoorEvent.OpenWithBlock)ExtensionsKt.post((Event)new TimedoorEvent.OpenWithBlock(timedoor, player, block, provider, locationId));
            if (event.isCanceled()) {
                Component component2 = event.getErrorMessage();
                if (component2 == null) {
                    component2 = (Component)this.getFail();
                }
                return component2;
            }
            String string = player.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.logTimedoorOpen(string, location, timedoor);
            ChrononHandler chrononHandler2 = ChrononHandlerKt.getChronons(block);
            if (chrononHandler2 != null) {
                chrononHandler2.extract(CommonConfig.TimeDoor.costPerDoor, ActionType.Execute);
            }
            block.setChanged();
            Level level2 = block.getLevel();
            Intrinsics.checkNotNull((Object)level2);
            level2.sendBlockUpdated(block.getBlockPos(), block.getBlockState(), block.getBlockState(), 3);
            Level level3 = block.getLevel();
            Intrinsics.checkNotNull((Object)level3);
            level3.addFreshEntity((Entity)timedoor);
            onOpen.invoke((Object)timedoor);
            timedoor.tryInitReceivingPortal();
            return null;
        }

        public static /* synthetic */ Component openTimedoor$default(Companion companion, GameProfile gameProfile, BlockEntity blockEntity, ResourceLocation resourceLocation, UUID uUID, NamedGlobalVec3 namedGlobalVec3, TimedoorPlacementSettings timedoorPlacementSettings, Function1 function1, int n, Object object) {
            if ((n & 0x20) != 0) {
                timedoorPlacementSettings = new DynamicAngledPlacement();
            }
            if ((n & 0x40) != 0) {
                function1 = Companion::openTimedoor$lambda$2;
            }
            return companion.openTimedoor(gameProfile, blockEntity, resourceLocation, uUID, namedGlobalVec3, timedoorPlacementSettings, (Function1<? super TimedoorEntity, Unit>)function1);
        }

        @NotNull
        public final Either<TimedoorEntity, Component> getTimedoor(@NotNull Level level, @NotNull NamedGlobalVec3 location, boolean ignoreRestrictions) {
            TimedoorEntity timedoorEntity;
            ResourceKey resourceKey;
            MinecraftServer targetHolder;
            block19: {
                block18: {
                    MinecraftServer minecraftServer;
                    Optional lookup;
                    block17: {
                        block16: {
                            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                            lookup = level.registryAccess().lookup(Registries.DIMENSION_TYPE);
                            minecraftServer = level.getServer();
                            if (minecraftServer == null || (minecraftServer = minecraftServer.getLevel(location.getDimension())) == null || (minecraftServer = minecraftServer.dimensionTypeRegistration()) == null || (minecraftServer = minecraftServer.getKey()) == null) break block16;
                            MinecraftServer it = minecraftServer;
                            boolean bl = false;
                            Optional optional = ((HolderLookup.RegistryLookup)lookup.get()).get((ResourceKey)it);
                            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"get(...)");
                            Holder.Reference reference = (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
                            minecraftServer = reference;
                            if (reference != null) break block17;
                        }
                        Either either = Either.right((Object)this.getPosFail());
                        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
                        return either;
                    }
                    targetHolder = minecraftServer;
                    resourceKey = level.dimensionTypeRegistration().getKey();
                    if (resourceKey == null) break block18;
                    ResourceKey it = resourceKey;
                    boolean bl = false;
                    Optional optional = ((HolderLookup.RegistryLookup)lookup.get()).get(it);
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"get(...)");
                    Holder.Reference reference = (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
                    resourceKey = reference;
                    if (reference != null) break block19;
                }
                Either either = Either.right((Object)this.getPosFail());
                Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
                return either;
            }
            ResourceKey sourceHolder = resourceKey;
            if (!ignoreRestrictions) {
                ResourceKey it = level.dimension();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, location.getDimension())) {
                    if (!CommonConfig.allowInterdimensionalTravel) {
                        Either either = Either.right((Object)Companion.getInterDimFail());
                        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
                        return either;
                    }
                    if (ExtensionsKt.contains(ModTags.INSTANCE.getLeavingNotSupported(), sourceHolder)) {
                        Either either = Either.right((Object)Companion.getLeavingFail());
                        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
                        return either;
                    }
                    if (ExtensionsKt.contains(ModTags.INSTANCE.getEnteringNotSupported(), targetHolder)) {
                        Either either = Either.right((Object)Companion.getEnteringFail());
                        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
                        return either;
                    }
                } else {
                    if (!CommonConfig.allowIntradimensionalTravel) {
                        Either either = Either.right((Object)Companion.getIntraDimAllFail());
                        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
                        return either;
                    }
                    if (ExtensionsKt.contains(ModTags.INSTANCE.getIntradimensionalTravelNotSupported(), sourceHolder)) {
                        Either either = Either.right((Object)Companion.getIntraDimFail());
                        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
                        return either;
                    }
                }
            }
            TimedoorEntity $this$getTimedoor_u24lambda_u247 = timedoorEntity = new TimedoorEntity(ModEntities.INSTANCE.getTimedoor(), level);
            boolean bl = false;
            $this$getTimedoor_u24lambda_u247.setLocation(location);
            Either either = Either.left((Object)((Object)timedoorEntity));
            Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
            return either;
        }

        public static /* synthetic */ Either getTimedoor$default(Companion companion, Level level, NamedGlobalVec3 namedGlobalVec3, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.getTimedoor(level, namedGlobalVec3, bl);
        }

        private final void logTimedoorOpen(String player, NamedGlobalVec3 location, TimedoorEntity timedoor) {
            if (CommonConfig.TimeDoor.logWhenOpen) {
                Tempad.Companion.getLogger().debug("Player {} opened a timedoor at {} in dimension {} to {} in dimension {}", (Object)player, (Object)timedoor.blockPosition(), (Object)timedoor.level().dimension(), (Object)location.getName(), timedoor.getTargetDimension());
            }
        }

        private static final Unit openTimedoor$lambda$0(TimedoorEntity it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return Unit.INSTANCE;
        }

        private static final Unit openTimedoor$lambda$2(TimedoorEntity it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

