/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.block;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.MapCodec;
import earth.terrarium.tempad.Tempad;
import earth.terrarium.tempad.api.tva_device.UpgradeHandler;
import earth.terrarium.tempad.api.tva_device.UpgradeHandlerKt;
import earth.terrarium.tempad.common.block.WorkstationBE;
import earth.terrarium.tempad.common.block.WorkstationBlock;
import earth.terrarium.tempad.common.recipe.TempadUpgradeRecipe;
import earth.terrarium.tempad.common.recipe.UpgradeRecipeInput;
import earth.terrarium.tempad.common.registries.ModBlocks;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.registries.ModItems;
import earth.terrarium.tempad.common.registries.ModRecipes;
import earth.terrarium.tempad.common.registries.ModSounds;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 F2\u00020\u0001:\u0001FB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J>\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u001a\u0018\u00010\u0019\"\n\b\u0000\u0010\u001a*\u0004\u0018\u00010\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001a0\u001dH\u0016J0\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0016\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010#\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010$\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020&H\u0016J2\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010+\u001a\u00020(2\u0016\u0010,\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010.\u0012\u0006\u0012\u0004\u0018\u00010\r0-H\u0014J\u0012\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0005H\u0014J\u0018\u0010/\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010\f\u001a\u00020\rH\u0014J(\u00102\u001a\u0002032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u0002042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010%\u001a\u000205H\u0014J(\u00106\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J8\u00107\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u00108\u001a\u00020\"2\u0006\u00109\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00112\u0006\u0010<\u001a\u00020\u0011H\u0014J\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000b0>2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010?\u001a\u00020@H\u0014J8\u0010A\u001a\u00020(2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010B\u001a\u00020.2\u0006\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020EH\u0014R\u001b\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006G"}, d2={"Learth/terrarium/tempad/common/block/WorkstationBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "getCodec", "()Lcom/mojang/serialization/MapCodec;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "getPos", "dir", "Lnet/minecraft/core/Direction;", "relativeDir", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "setPlacedBy", "", "placer", "Lnet/minecraft/world/entity/LivingEntity;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "newBlockEntity", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "playerWillDestroy", "updateShape", "facing", "facingState", "Lnet/minecraft/world/level/LevelAccessor;", "currentPos", "neighborPos", "getDrops", "", "params", "Lnet/minecraft/world/level/storage/loot/LootParams$Builder;", "neighborChanged", "block", "fromPos", "isMoving", "", "Companion", "tempad-1.21.1"})
public final class WorkstationBlock
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MapCodec<? extends BaseEntityBlock> codec;
    @NotNull
    private static final BooleanProperty HAS_TAPE;
    @NotNull
    private static final VoxelShape NORTH_SHAPE;
    @NotNull
    private static final VoxelShape SOUTH_SHAPE;
    @NotNull
    private static final VoxelShape WEST_SHAPE;
    @NotNull
    private static final VoxelShape EAST_SHAPE;

    public WorkstationBlock() {
        super(BlockBehaviour.Properties.of().noOcclusion().strength(3.0f, 1200.0f));
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(WorkstationBlock::codec$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        this.codec = mapCodec;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_TAPE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public final MapCodec<? extends BaseEntityBlock> getCodec() {
        return this.codec;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        block9: {
            TempadUpgradeRecipe recipe2;
            WorkstationBE blockEntity;
            block11: {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                    Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                    Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                    Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                    Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
                    Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
                    if (level.isClientSide) {
                        return ItemInteractionResult.SUCCESS;
                    }
                    BlockEntity blockEntity2 = level.getBlockEntity(pos);
                    WorkstationBE workstationBE = blockEntity2 instanceof WorkstationBE ? (WorkstationBE)blockEntity2 : null;
                    if (workstationBE == null) {
                        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                    }
                    blockEntity = workstationBE;
                    if (ExtensionsKt.get(blockEntity.getInventory(), 0).isEmpty() && stack.is((Item)ModItems.INSTANCE.getTempad())) {
                        ModComponentsKt.setOwner((MutableDataComponentHolder)stack, player.getGameProfile());
                        ExtensionsKt.set(blockEntity.getInventory(), 0, stack);
                        blockEntity.setChanged();
                        player.setItemInHand(hand, ItemStack.EMPTY);
                        level.sendBlockUpdated(pos, state, state, 3);
                        return ItemInteractionResult.SUCCESS;
                    }
                    if (ExtensionsKt.get(blockEntity.getInventory(), 0).isEmpty() || blockEntity.getDownloadTime() != 0) break block9;
                    Optional optional = level.getRecipeManager().getRecipeFor(ModRecipes.INSTANCE.getUpgradeRecipe(), (RecipeInput)new UpgradeRecipeInput(ExtensionsKt.get(blockEntity.getInventory(), 0), stack), level);
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getRecipeFor(...)");
                    RecipeHolder recipeHolder = (RecipeHolder)OptionalsKt.getOrNull((Optional)optional);
                    TempadUpgradeRecipe tempadUpgradeRecipe = recipe2 = recipeHolder != null ? (TempadUpgradeRecipe)recipeHolder.value() : null;
                    if (recipe2 == null) break block10;
                    UpgradeHandler upgradeHandler = UpgradeHandlerKt.getUpgrades(blockEntity);
                    Intrinsics.checkNotNull((Object)upgradeHandler);
                    if (!upgradeHandler.contains(recipe2.getOutput())) break block11;
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            ServerPlayer serverPlayer = player instanceof ServerPlayer ? (ServerPlayer)player : null;
            if (serverPlayer != null) {
                ServerPlayer it = serverPlayer;
                boolean bl = false;
                ((ServerPlayer)player).connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)ModSounds.INSTANCE.getUpgradePlaceMono()), SoundSource.BLOCKS, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.0f, 1.0f, 0L));
                level.playSound((Player)it, pos, ModSounds.INSTANCE.getUpgradePlaceStereo(), SoundSource.BLOCKS);
            }
            level.playSound(null, pos, ModSounds.INSTANCE.getUpgradeInstalling(), SoundSource.BLOCKS);
            blockEntity.setDownloadTime(recipe2.getDownloadTime());
            blockEntity.setMaxDownloadTime(recipe2.getDownloadTime());
            blockEntity.setRecipe(recipe2.getOutput());
            stack.shrink(1);
            blockEntity.setChanged();
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_TAPE, (Comparable)Boolean.valueOf(true)), 3);
            if (stack.isEmpty()) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(type2, ModBlocks.INSTANCE.getWorkstationBE(), (BlockEntityTicker)getTicker.1.INSTANCE);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Object[] objectArray = level.getBlockEntity(pos);
        WorkstationBE workstationBE = objectArray instanceof WorkstationBE ? (WorkstationBE)objectArray : null;
        if (workstationBE == null) {
            return InteractionResult.PASS;
        }
        WorkstationBE blockEntity = workstationBE;
        if (blockEntity.getMaxDownloadTime() > 0) {
            return InteractionResult.PASS;
        }
        ItemStack stack = ExtensionsKt.get(blockEntity.getInventory(), 0);
        if (ModComponentsKt.getLocked((MutableDataComponentHolder)stack)) {
            GameProfile gameProfile = ModComponentsKt.getOwner((MutableDataComponentHolder)stack);
            if (!Intrinsics.areEqual((Object)(gameProfile != null ? gameProfile.getId() : null), (Object)player.getGameProfile().getId())) {
                objectArray = new Object[]{this.getName()};
                player.displayClientMessage((Component)Component.translatable((String)"error.tempad.block_locked", (Object[])objectArray).withColor(Tempad.Companion.getORANGE().getValue()), true);
                return InteractionResult.FAIL;
            }
        }
        ModComponentsKt.setOwner((MutableDataComponentHolder)stack, null);
        if (player.getMainHandItem().isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, stack.copy());
        } else {
            player.getInventory().placeItemBackInInventory(stack.copy());
        }
        ItemStackHandler itemStackHandler = blockEntity.getInventory();
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        ExtensionsKt.set(itemStackHandler, 0, itemStack);
        level.sendBlockUpdated(pos, state, state, 3);
        blockEntity.setChanged();
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public final BlockPos getPos(@NotNull Direction dir, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos blockPos = pos.relative(Direction.fromYRot((double)((double)dir.toYRot() - 90.0)));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
        return blockPos;
    }

    @NotNull
    public final Direction relativeDir(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Direction direction = Direction.fromYRot((double)((double)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() - 90.0));
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"fromYRot(...)");
        return direction;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = context.getHorizontalDirection();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getHorizontalDirection(...)");
        Direction direction2 = direction;
        BlockPos blockPos = context.getClickedPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getClickedPos(...)");
        BlockPos childPos = this.getPos(direction2, blockPos);
        Level level = context.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        Level level2 = level;
        return level2.getBlockState(childPos).canBeReplaced(context) && level2.getWorldBorder().isWithinBounds(childPos) ? (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction2) : null;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide) {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BlockState newState = (BlockState)ModBlocks.INSTANCE.getWorkstationChild().defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)dir);
            Intrinsics.checkNotNull((Object)dir);
            BlockPos blockpos = this.getPos(dir, pos);
            level.setBlock(blockpos, newState, 3);
            level.blockUpdated(pos, Blocks.AIR);
            newState.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING};
        StateDefinition.Builder builder2 = builder.add(propertyArray);
        propertyArray = new Property[]{HAS_TAPE};
        builder2.add(propertyArray);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new WorkstationBE(pos, state);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> NORTH_SHAPE;
            case 2 -> SOUTH_SHAPE;
            case 3 -> WEST_SHAPE;
            case 4 -> EAST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!level.isClientSide && player.isCreative()) {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Intrinsics.checkNotNull((Object)dir);
            BlockPos blockpos = this.getPos(dir, pos);
            BlockState blockstate = level.getBlockState(blockpos);
            if (blockstate.is((Block)ModBlocks.INSTANCE.getWorkstationChild()) && state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == dir) {
                level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
                level.levelEvent(player, 2001, blockpos, BaseEntityBlock.getId((BlockState)blockstate));
            }
        }
        BlockState blockState = super.playerWillDestroy(level, pos, state, player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"playerWillDestroy(...)");
        return blockState;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)facingState, (String)"facingState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (facing == this.relativeDir(state) && Intrinsics.areEqual((Object)facingState.getBlock(), (Object)Blocks.AIR)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNull((Object)blockState2);
            blockState = blockState2;
        } else {
            BlockState blockState3 = super.updateShape(state, facing, facingState, level, currentPos, neighborPos);
            Intrinsics.checkNotNull((Object)blockState3);
            blockState = blockState3;
        }
        return blockState;
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, @NotNull LootParams.Builder params) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List list = super.getDrops(state, params);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDrops(...)");
        List drops = CollectionsKt.toMutableList((Collection)list);
        BlockEntity blockE = (BlockEntity)params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockE instanceof WorkstationBE && !ExtensionsKt.get(((WorkstationBE)blockE).getInventory(), 0).isEmpty()) {
            drops.add(ExtensionsKt.get(((WorkstationBE)blockE).getInventory(), 0));
        }
        return CollectionsKt.toList((Iterable)drops);
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        boolean neighborPowered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        BlockEntity blockEntity = level.getBlockEntity(pos);
        WorkstationBE workstationBE = blockEntity instanceof WorkstationBE ? (WorkstationBE)blockEntity : null;
        if (workstationBE == null) {
            return;
        }
        WorkstationBE blockEntity2 = workstationBE;
        if (neighborPowered && !blockEntity2.getActive()) {
            blockEntity2.activateRight();
        } else if (!neighborPowered && blockEntity2.getActive()) {
            blockEntity2.deactivateRight();
        }
    }

    private static final WorkstationBlock codec$lambda$0(BlockBehaviour.Properties it) {
        return ModBlocks.INSTANCE.getWorkstation();
    }

    static {
        BooleanProperty booleanProperty = BooleanProperty.create((String)"has_tape");
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"create(...)");
        HAS_TAPE = booleanProperty;
        VoxelShape voxelShape = Shapes.or((VoxelShape)BaseEntityBlock.box((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)2.0, (double)15.0), (VoxelShape)BaseEntityBlock.box((double)0.0, (double)2.0, (double)1.0, (double)14.0, (double)4.0, (double)5.0));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"or(...)");
        NORTH_SHAPE = voxelShape;
        VoxelShape voxelShape2 = Shapes.or((VoxelShape)BaseEntityBlock.box((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)15.0), (VoxelShape)BaseEntityBlock.box((double)2.0, (double)2.0, (double)11.0, (double)16.0, (double)4.0, (double)15.0));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"or(...)");
        SOUTH_SHAPE = voxelShape2;
        VoxelShape voxelShape3 = Shapes.or((VoxelShape)BaseEntityBlock.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)2.0, (double)16.0), (VoxelShape)BaseEntityBlock.box((double)1.0, (double)2.0, (double)2.0, (double)5.0, (double)4.0, (double)16.0));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"or(...)");
        WEST_SHAPE = voxelShape3;
        VoxelShape voxelShape4 = Shapes.or((VoxelShape)BaseEntityBlock.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)14.0), (VoxelShape)BaseEntityBlock.box((double)11.0, (double)2.0, (double)0.0, (double)15.0, (double)4.0, (double)14.0));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"or(...)");
        EAST_SHAPE = voxelShape4;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0012"}, d2={"Learth/terrarium/tempad/common/block/WorkstationBlock$Companion;", "", "<init>", "()V", "HAS_TAPE", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getHAS_TAPE", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "NORTH_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getNORTH_SHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "SOUTH_SHAPE", "getSOUTH_SHAPE", "WEST_SHAPE", "getWEST_SHAPE", "EAST_SHAPE", "getEAST_SHAPE", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getHAS_TAPE() {
            return HAS_TAPE;
        }

        @NotNull
        public final VoxelShape getNORTH_SHAPE() {
            return NORTH_SHAPE;
        }

        @NotNull
        public final VoxelShape getSOUTH_SHAPE() {
            return SOUTH_SHAPE;
        }

        @NotNull
        public final VoxelShape getWEST_SHAPE() {
            return WEST_SHAPE;
        }

        @NotNull
        public final VoxelShape getEAST_SHAPE() {
            return EAST_SHAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

