/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.api.tva_device.impl;

import earth.terrarium.tempad.api.ActionType;
import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.common.data.MetronomeData;
import earth.terrarium.tempad.common.registries.ModAttachmentsKt;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0013"}, d2={"Learth/terrarium/tempad/api/tva_device/impl/MultiversalChrononHandler;", "Learth/terrarium/tempad/api/tva_device/ChrononHandler;", "playerId", "Ljava/util/UUID;", "<init>", "(Ljava/util/UUID;)V", "getPlayerId", "()Ljava/util/UUID;", "power", "", "getPower", "()I", "maxPower", "getMaxPower", "extract", "amount", "action", "Learth/terrarium/tempad/api/ActionType;", "insert", "tempad-1.21.1"})
public final class MultiversalChrononHandler
implements ChrononHandler {
    @NotNull
    private final UUID playerId;

    public MultiversalChrononHandler(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        this.playerId = playerId;
    }

    @NotNull
    public final UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    public int getPower() {
        MetronomeData metronomeData = ModAttachmentsKt.getMetronomeEnergy();
        return metronomeData != null ? metronomeData.getStored(this.playerId) : 0;
    }

    @Override
    public int getMaxPower() {
        MetronomeData metronomeData = ModAttachmentsKt.getMetronomeEnergy();
        return metronomeData != null ? metronomeData.getCapacity(this.playerId) : 0;
    }

    @Override
    public int extract(int amount, @NotNull ActionType action) {
        int newPower;
        int oldPower;
        block0: {
            MetronomeData metronomeData;
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            oldPower = this.getPower();
            newPower = RangesKt.coerceAtLeast((int)(this.getPower() - amount), (int)0);
            if (action != ActionType.Execute || (metronomeData = ModAttachmentsKt.getMetronomeEnergy()) == null) break block0;
            Integer n = newPower;
            ((Map)metronomeData.getStored()).put(this.playerId, n);
        }
        return oldPower - newPower;
    }

    @Override
    public int insert(int amount, @NotNull ActionType action) {
        int newPower;
        int oldPower;
        block0: {
            MetronomeData metronomeData;
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            oldPower = this.getPower();
            newPower = RangesKt.coerceAtMost((int)(this.getPower() + amount), (int)this.getMaxPower());
            if (action != ActionType.Execute || (metronomeData = ModAttachmentsKt.getMetronomeEnergy()) == null) break block0;
            Integer n = newPower;
            ((Map)metronomeData.getStored()).put(this.playerId, n);
        }
        return newPower - oldPower;
    }
}

