/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.content.trading_depot;

import com.cake.trading_floor.Config;
import com.cake.trading_floor.content.trading_depot.TradingDepotBlock;
import com.cake.trading_floor.content.trading_depot.behavior.TradingDepotBehaviour;
import com.cake.trading_floor.content.trading_depot.behavior.TradingDepotValueBox;
import com.cake.trading_floor.foundation.AttachedTradingDepotFinder;
import com.cake.trading_floor.foundation.MerchantOfferInfo;
import com.cake.trading_floor.foundation.TFLang;
import com.cake.trading_floor.foundation.advancement.TFAdvancementBehaviour;
import com.cake.trading_floor.foundation.advancement.TFAdvancements;
import com.cake.trading_floor.registry.TFParticleEmitters;
import com.cake.trading_floor.registry.TFRegistry;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class TradingDepotBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    TradingDepotBehaviour tradingDepotBehaviour;
    FilteringBehaviour filtering;
    List<BlockEntity> tradingDepotsForDisplay = new ArrayList<BlockEntity>();
    @Nullable
    MerchantOfferInfo lastTrade;
    int lastTradeCount = 0;
    int tradeOutputSum = 0;
    int currentTradeCompletedCount = 0;
    int emeraldsProduced = 0;

    public TradingDepotBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        int tradingDepotOtherSourceCount;
        BlockPos attachedWorkstationPosition = this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)TradingDepotBlock.FACING)).getOpposite());
        this.updateOtherSourcesForTooltip(attachedWorkstationPosition);
        this.tradingDepotBehaviour.addContentsToTooltip(tooltip);
        if (this.lastTrade != null) {
            TFLang.translate("tooltip.trading_depot.last_trade", new Object[0]).add(TFLang.text(" (x" + this.lastTradeCount + ")").color(this.lastTradeCount == 0 ? 0xFF5555 : 0x55FFFF)).forGoggles(tooltip);
            this.addTradeToGoggles(tooltip, this.lastTrade);
        }
        if ((tradingDepotOtherSourceCount = this.tradingDepotsForDisplay.size() - 1) > 0) {
            TFLang.text("").forGoggles(tooltip);
            TFLang.translate("tooltip.trading_depot.connected_to_other", new Object[0]).add(TFLang.text(" " + tradingDepotOtherSourceCount + " ").style(ChatFormatting.AQUA)).translate("tooltip.trading_depot.other_trading_depot" + (tradingDepotOtherSourceCount > 1 ? "s" : ""), new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
        }
        return true;
    }

    private void addTradeToGoggles(List<Component> tooltip, MerchantOfferInfo trade) {
        LangBuilder costText = TFLang.itemStack(trade.getCostA());
        if (!trade.getCostB().isEmpty()) {
            costText.text(" + ").add(TFLang.itemStack(trade.getCostB())).style(ChatFormatting.GRAY);
        }
        costText.forGoggles(tooltip, 1);
        TFLang.text("\u2192 ").add(TFLang.itemStack(trade.getResult())).style(ChatFormatting.WHITE).forGoggles(tooltip, 2);
    }

    private void updateOtherSourcesForTooltip(BlockPos attachedWorkstationPosition) {
        if (this.level == null) {
            this.tradingDepotsForDisplay = new ArrayList<BlockEntity>();
            return;
        }
        this.tradingDepotsForDisplay = AttachedTradingDepotFinder.lookForTradingDepots((LevelAccessor)this.level, attachedWorkstationPosition).stream().map(blockPos -> this.level.getBlockEntity(blockPos)).filter(blockEntity -> blockEntity instanceof TradingDepotBlockEntity).toList();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tradingDepotBehaviour = new TradingDepotBehaviour(this);
        behaviours.add(this.tradingDepotBehaviour);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new TradingDepotValueBox()).withCallback($ -> this.tradingDepotBehaviour.resetInv());
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.filtering.setLabel(TFLang.translate("tooltip.trading_depot.filtering.trade_filter", new Object[0]).component());
        TFAdvancementBehaviour.create(behaviours, this, TFAdvancements.MONEY_MONEY_MONEY, TFAdvancements.BUDDING_CAPITALIST, TFAdvancements.HAPPY_JEFF);
        this.tradingDepotBehaviour.filtering = this.filtering;
        this.tradingDepotBehaviour.addAdditionalBehaviours(behaviours);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TFRegistry.TRADING_DEPOT_BLOCK_ENTITY.get(), (be, context) -> be.tradingDepotBehaviour.getRealItemHandler());
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (tag.contains("LastTrade")) {
            this.lastTrade = MerchantOfferInfo.read(registries, tag.getCompound("LastTrade"));
        }
        this.lastTradeCount = tag.getInt("LastTradeCount");
        this.emeraldsProduced = tag.getInt("EmeraldsProduced");
        this.tradeOutputSum = tag.getInt("TradeOutputSum");
        this.currentTradeCompletedCount = tag.getInt("CurrentTradeCompletedCount");
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.lastTrade != null) {
            tag.put("LastTrade", this.lastTrade.write(registries, new CompoundTag()));
        }
        tag.putInt("LastTradeCount", this.lastTradeCount);
        if (((TFAdvancementBehaviour)this.getBehaviour(TFAdvancementBehaviour.TYPE)).isOwnerPresent()) {
            tag.putInt("EmeraldsProduced", this.emeraldsProduced);
        }
        tag.putInt("TradeOutputSum", this.tradeOutputSum);
        tag.putInt("CurrentTradeCompletedCount", this.currentTradeCompletedCount);
    }

    protected boolean tryTakeMerchantOffer(MerchantOffer offer, TradingDepotBehaviour costASource, List<TradingDepotBehaviour> costBSources) {
        if (!ItemStack.isSameItem((ItemStack)offer.getBaseCostA(), (ItemStack)costASource.getOfferStack())) {
            return false;
        }
        ItemStack totalCostBSource = ItemStack.EMPTY;
        if (!offer.getCostB().isEmpty()) {
            if ((costBSources = costBSources.stream().filter(depot -> ItemStack.isSameItem((ItemStack)offer.getCostB(), (ItemStack)depot.getOfferStack())).toList()).isEmpty()) {
                return false;
            }
            int totalCostB = 0;
            for (TradingDepotBehaviour depot2 : costBSources) {
                totalCostB += depot2.getOfferStack().getCount();
            }
            if (offer.getCostB().getCount() > totalCostB) {
                return false;
            }
            totalCostBSource = costBSources.get(0).getOfferStack().copyWithCount(totalCostB);
        }
        if (!TradingDepotBlockEntity.satisfiedBaseCostBy(offer, costASource.getOfferStack(), totalCostBSource)) {
            return false;
        }
        costASource.setOfferStack(costASource.getOfferStack().copyWithCount(costASource.getOfferStack().getCount() - offer.getBaseCostA().getCount()));
        this.takeTotalFromSources(costBSources, offer.getCostB().getCount());
        costASource.getResults().add(offer.assemble());
        return true;
    }

    protected void takeTotalFromSources(List<TradingDepotBehaviour> costBSources, int totalExtractCount) {
        int i = 0;
        while (totalExtractCount > 0) {
            if (costBSources.size() <= i) {
                return;
            }
            TradingDepotBehaviour costSource = costBSources.get(i);
            int currentCount = costSource.getOfferStack().getCount();
            int extractCount = Math.min(totalExtractCount, currentCount);
            costSource.setOfferStack(costSource.getOfferStack().copyWithCount(currentCount - extractCount));
            totalExtractCount -= extractCount;
            ++i;
        }
    }

    public void tryTradeWith(Villager villager, List<TradingDepotBehaviour> allDepots) {
        if (!this.tradingDepotBehaviour.isOutputEmpty()) {
            return;
        }
        List<TradingDepotBehaviour> costBSources = allDepots.stream().filter(depot -> depot != this.tradingDepotBehaviour).toList();
        boolean hadSuccessfulTrade = false;
        boolean hasSpace = true;
        MerchantOfferInfo latestTrade = null;
        int latestTradeCount = 0;
        for (MerchantOffer offer : villager.getOffers()) {
            if (!hasSpace) break;
            if (!this.filtering.getFilter().isEmpty() && (!(this.filtering.getFilter().getItem() instanceof FilterItem) || !this.filtering.test(offer.getResult())) && !TradingDepotBlockEntity.isRequiredItem(offer.getResult(), this.filtering.getFilter())) continue;
            List<TradingDepotBehaviour> filteredCostBSources = costBSources.stream().filter(depot -> depot.canBeUsedFor(offer)).toList();
            boolean trading = true;
            while (trading) {
                if (this.tradingDepotBehaviour.getResults().size() >= 8) {
                    this.tradingDepotBehaviour.combineOutputs();
                    if (this.tradingDepotBehaviour.getResults().size() >= 8) {
                        hasSpace = false;
                        break;
                    }
                }
                if (trading = this.tryTakeMerchantOffer(offer, this.tradingDepotBehaviour, filteredCostBSources)) {
                    latestTrade = new MerchantOfferInfo(offer);
                    ++latestTradeCount;
                }
                boolean bl = hadSuccessfulTrade = hadSuccessfulTrade || trading;
                if (latestTradeCount < Config.maxTradePerWork) continue;
            }
            if (!hadSuccessfulTrade) continue;
            break;
        }
        if (hadSuccessfulTrade) {
            this.tradingDepotBehaviour.combineOutputs();
            villager.playCelebrateSound();
            ((TFAdvancementBehaviour)this.getBehaviour(TFAdvancementBehaviour.TYPE)).awardPlayer(TFAdvancements.MONEY_MONEY_MONEY);
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                TFParticleEmitters.TRADE_COMPLETED.emitToClients(serverLevel, Vec3.atCenterOf((Vec3i)this.getBlockPos()).add(0.0, 0.4, 0.0), 4);
            }
        }
        if (latestTrade != null && !Objects.equals(this.lastTrade, latestTrade)) {
            this.currentTradeCompletedCount = 0;
            this.tradeOutputSum = 0;
        }
        this.lastTrade = latestTrade;
        if (latestTrade != null) {
            this.currentTradeCompletedCount += latestTradeCount;
            this.tradeOutputSum += latestTradeCount * latestTrade.getResult().getCount();
            this.lastTradeCount = latestTradeCount;
        }
        this.checkForAwardedAdvancements();
        this.notifyUpdate();
    }

    private void checkForAwardedAdvancements() {
        if (this.lastTrade != null && this.lastTrade.getResult().is(Items.EMERALD)) {
            TFAdvancementBehaviour advancementBehaviour = (TFAdvancementBehaviour)this.getBehaviour(TFAdvancementBehaviour.TYPE);
            if (this.tradeOutputSum >= 64) {
                advancementBehaviour.awardPlayer(TFAdvancements.BUDDING_CAPITALIST);
            }
            if (this.tradeOutputSum >= 1000) {
                advancementBehaviour.awardPlayer(TFAdvancements.HAPPY_JEFF);
            }
        }
    }

    public static boolean satisfiedBaseCostBy(MerchantOffer offer, ItemStack playerOfferA, ItemStack playerOfferB) {
        return TradingDepotBlockEntity.isRequiredItem(playerOfferA, offer.getBaseCostA()) && playerOfferA.getCount() >= offer.getBaseCostA().getCount() && TradingDepotBlockEntity.isRequiredItem(playerOfferB, offer.getCostB()) && playerOfferB.getCount() >= offer.getCostB().getCount();
    }

    private static boolean isRequiredItem(ItemStack available, ItemStack cost) {
        if (cost.isEmpty() && available.isEmpty()) {
            return true;
        }
        ItemStack itemstack = available.copy();
        if (itemstack.getItem().isDamageable(itemstack)) {
            itemstack.setDamageValue(itemstack.getDamageValue());
        }
        return ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)cost);
    }

    public boolean hasInputStack() {
        return this.tradingDepotBehaviour.getOffer() != null && !this.tradingDepotBehaviour.getOfferStack().isEmpty();
    }

    public int getCurrentTradeCompletedCount() {
        return this.currentTradeCompletedCount;
    }

    public int getTradeOutputSum() {
        return this.tradeOutputSum;
    }

    @Nullable
    public MerchantOfferInfo getLastTrade() {
        return this.lastTrade;
    }
}

