/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.test;

import dev.technici4n.moderndynamics.attachment.settings.RedstoneMode;
import dev.technici4n.moderndynamics.attachment.settings.RoutingMode;
import dev.technici4n.moderndynamics.init.MdBlocks;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.test.MdGameTest;
import dev.technici4n.moderndynamics.test.framework.MdGameTestHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;

public class ItemDistributionTest {
    @MdGameTest(timeoutTicks=200)
    public void testRoundRobinInvalidTarget(MdGameTestHelper helper) {
        BlockPos sourceChest = new BlockPos(0, 1, 0);
        helper.setBlock(sourceChest, Blocks.CHEST);
        BlockPos targetChest1 = new BlockPos(2, 1, 0);
        helper.setBlock(targetChest1, Blocks.CHEST);
        BlockPos targetChest2 = new BlockPos(2, 1, 1);
        helper.setBlock(targetChest2, Blocks.CHEST);
        BlockPos targetChest3 = new BlockPos(2, 1, 2);
        helper.setBlock(targetChest3, Blocks.CHEST);
        BlockPos pipePos = new BlockPos(1, 1, 0);
        helper.pipe(pipePos, MdBlocks.ITEM_PIPE).attachment(Direction.WEST, MdItems.EXTRACTOR).configureItemIo(Direction.WEST, io -> {
            io.setUpgrade(0, Items.COMPARATOR.getDefaultInstance());
            io.setUpgrade(1, new ItemStack((ItemLike)Items.REPEATER, 3));
            io.setUpgrade(2, Items.STICKY_PISTON.getDefaultInstance());
            io.setMaxItemsExtracted(1);
            io.setRoutingMode(RoutingMode.ROUND_ROBIN);
        });
        helper.pipe(new BlockPos(1, 1, 1), MdBlocks.ITEM_PIPE).attachment(Direction.EAST, MdItems.FILTER).configureItemIo(Direction.EAST, io -> io.setRedstoneMode(RedstoneMode.REQUIRES_HIGH));
        helper.pipe(new BlockPos(1, 1, 2), MdBlocks.ITEM_PIPE);
        ((ChestBlockEntity)helper.getBlockEntity(sourceChest)).setItem(0, new ItemStack((ItemLike)Items.DIAMOND, 6));
        helper.startSequence().thenWaitUntil(() -> {
            helper.assertContainerEmpty(sourceChest);
            helper.checkItem(targetChest1, Items.DIAMOND, 3);
            helper.checkItem(targetChest2, Items.DIAMOND, 0);
            helper.checkItem(targetChest3, Items.DIAMOND, 3);
        }).thenSucceed();
    }
}

