/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.mienergy;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.compat.mi.MIProxy;
import dev.technici4n.moderndynamics.network.HostAdjacentCaps;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.mienergy.MICableTier;
import dev.technici4n.moderndynamics.network.mienergy.MIEnergyCache;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class MIEnergyHost
extends NodeHost {
    private static final NetworkManager<MIEnergyHost, MIEnergyCache> MANAGER = NetworkManager.get(MIEnergyCache.class, MIEnergyCache::new);
    public final MICableTier tier;
    private long energy = 0L;
    private final HostAdjacentCaps<? extends IEnergyStorage> adjacentCaps = new HostAdjacentCaps<IEnergyStorage>(this, MIProxy.INSTANCE.getLookup());

    public MIEnergyHost(PipeBlockEntity pipe, MICableTier tier) {
        super(pipe);
        this.tier = tier;
    }

    @Override
    protected void doUpdate() {
        this.updateConnections();
    }

    @Override
    public boolean acceptsAttachment(AttachmentItem attachment, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canConnectTo(Direction connectionDirection, NodeHost adjacentHost) {
        return super.canConnectTo(connectionDirection, adjacentHost) && ((MIEnergyHost)adjacentHost).tier == this.tier;
    }

    public void gatherCapabilities(@Nullable List<IEnergyStorage> out) {
        int oldConnections = this.inventoryConnections;
        for (int i = 0; i < 6; ++i) {
            if ((this.inventoryConnections & 1 << i) <= 0 || (this.pipeConnections & 1 << i) != 0) continue;
            Direction dir = Direction.from3DDataValue((int)i);
            IEnergyStorage adjacentCap = this.adjacentCaps.getCapability(dir);
            if (adjacentCap != null && MIProxy.INSTANCE.canConnect(adjacentCap, this.tier)) {
                if (out == null) continue;
                out.add(adjacentCap);
                continue;
            }
            this.inventoryConnections ^= 1 << i;
        }
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    public void updateConnections() {
        int oldConnections = this.inventoryConnections;
        this.inventoryConnections = 63 - (this.pipeConnections | this.pipe.connectionBlacklist);
        this.gatherCapabilities(null);
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeNbt(tag, registries);
        tag.putLong("mi_energy", this.energy);
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries) {
        super.readNbt(tag, registries);
        this.energy = Math.max(0L, Math.min(tag.getLong("mi_energy"), this.getMaxEnergy()));
    }

    @Override
    public NetworkManager<MIEnergyHost, MIEnergyCache> getManager() {
        return MANAGER;
    }

    @Override
    @Nullable
    public Object getApiInstance(BlockCapability<?, Direction> lookup, @Nullable Direction side) {
        return null;
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getMaxEnergy() {
        return this.tier.getMax();
    }

    public void setEnergy(long energy) {
        if (energy < 0L || energy > this.getMaxEnergy()) {
            throw new IllegalArgumentException("Invalid energy value " + energy);
        }
        this.energy = energy;
        this.pipe.setChanged();
    }
}

