/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentType;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.attachment.settings.RoutingMode;
import dev.technici4n.moderndynamics.network.HostAdjacentCaps;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.TickHelper;
import dev.technici4n.moderndynamics.network.item.FailedInsertStrategy;
import dev.technici4n.moderndynamics.network.item.InsertionOnlyItemHandler;
import dev.technici4n.moderndynamics.network.item.ItemCache;
import dev.technici4n.moderndynamics.network.item.ItemPath;
import dev.technici4n.moderndynamics.network.item.ItemPathCache;
import dev.technici4n.moderndynamics.network.item.MaxParticipant;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTarget;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTargets;
import dev.technici4n.moderndynamics.network.item.TravelingItem;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItem;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItemSmoothing;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.DropHelper;
import dev.technici4n.moderndynamics.util.ItemVariant;
import dev.technici4n.moderndynamics.util.SerializationHelper;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.jetbrains.annotations.Nullable;

public class ItemHost
extends NodeHost {
    public static final NetworkManager<ItemHost, ItemCache> MANAGER = NetworkManager.get(ItemCache.class, ItemCache::new);
    private final List<TravelingItem> travelingItems = new ArrayList<TravelingItem>();
    private final List<ClientTravelingItem> clientTravelingItems = new ArrayList<ClientTravelingItem>();
    private final long[] lastOperationTick = new long[6];
    private final HostAdjacentCaps<IItemHandler> adjacentCaps = new HostAdjacentCaps(this, Capabilities.ItemHandler.BLOCK);

    public ItemHost(PipeBlockEntity pipe) {
        super(pipe);
    }

    @Override
    public boolean acceptsAttachment(AttachmentItem attachment, ItemStack stack) {
        return true;
    }

    @Override
    public NetworkManager<ItemHost, ItemCache> getManager() {
        return MANAGER;
    }

    @Override
    public boolean canConnectTo(Direction connectionDirection, NodeHost adjacentHost) {
        AttachedAttachment attachment = this.getAttachment(connectionDirection);
        if (attachment instanceof ItemAttachedIo) {
            return false;
        }
        return super.canConnectTo(connectionDirection, adjacentHost);
    }

    @Override
    @Nullable
    public Object getApiInstance(BlockCapability<?, Direction> lookup, @Nullable Direction side) {
        if (lookup == Capabilities.ItemHandler.BLOCK && side != null && this.allowItemConnection(side)) {
            return this.buildExternalNetworkInjectStorage(side);
        }
        return null;
    }

    private boolean allowItemConnection(Direction side) {
        AttachedAttachment attachment = this.getAttachment(side);
        return attachment == null || attachment.allowsItemConnection();
    }

    private IItemHandler buildExternalNetworkInjectStorage(Direction side) {
        return new InsertionOnlyItemHandler((resource, maxAmount, simulate) -> {
            NetworkNode<ItemHost, ItemCache> node = this.findNode();
            if (node != null) {
                double d;
                ItemCache cache = (ItemCache)node.getNetworkCache();
                List<ItemPath> paths = cache.pathCache.getPaths(node, side.getOpposite());
                AttachedAttachment patt0$temp = this.getAttachment(side);
                if (patt0$temp instanceof ItemAttachedIo) {
                    ItemAttachedIo io = (ItemAttachedIo)patt0$temp;
                    d = io.getItemSpeedupFactor();
                } else {
                    d = 1.0;
                }
                double speedupFactor = d;
                return cache.insertList(node, paths, resource, maxAmount, simulate, speedupFactor, null);
            }
            return 0;
        });
    }

    private InsertionOnlyItemHandler buildExtractorNetworkInjectStorage(Direction side, ItemAttachedIo extractor, @Nullable MaxParticipant maxIndexParticipant) {
        double speedupFactor = extractor.getItemSpeedupFactor();
        NetworkNode<ItemHost, ItemCache> node = this.findNode();
        ItemCache cache = (ItemCache)node.getNetworkCache();
        Iterable<ItemPath> paths = this.rearrangePaths(cache.pathCache.getPaths(node, side.getOpposite()), extractor);
        return new InsertionOnlyItemHandler((resource, maxAmount, simulate) -> cache.insertList(node, paths, resource, maxAmount, simulate, speedupFactor, maxIndexParticipant));
    }

    protected EnumSet<Direction> getInventoryConnections() {
        return SerializationHelper.directionsFromMask((byte)this.inventoryConnections);
    }

    @Nullable
    protected IItemHandler getAdjacentStorage(Direction side, boolean checkAttachments) {
        if ((this.inventoryConnections & 1 << side.get3DDataValue()) > 0 && (this.pipeConnections & 1 << side.get3DDataValue()) == 0 && (!checkAttachments || this.allowItemConnection(side))) {
            return this.adjacentCaps.getCapability(side);
        }
        return null;
    }

    private Iterable<ItemPath> rearrangePaths(List<ItemPath> path, ItemAttachedIo io) {
        if (path.size() <= 1) {
            return path;
        }
        return switch (io.getRoutingMode()) {
            default -> throw new MatchException(null, null);
            case RoutingMode.CLOSEST -> path;
            case RoutingMode.FURTHEST -> Lists.reverse(path);
            case RoutingMode.RANDOM -> {
                ArrayList pathCopy = new ArrayList(path);
                Collections.shuffle(pathCopy);
                yield pathCopy;
            }
            case RoutingMode.ROUND_ROBIN -> {
                int startIndex = io.getRoundRobinIndex(path.size());
                yield Iterables.concat(path.subList(startIndex, path.size()), path.subList(0, startIndex));
            }
        };
    }

    public void tickAttachments() {
        long currentTick = TickHelper.getTickCounter();
        for (Direction side : Direction.values()) {
            ItemAttachedIo itemAttachedIo;
            AttachedAttachment attachment = this.getAttachment(side);
            if (!(attachment instanceof ItemAttachedIo) || !(itemAttachedIo = (ItemAttachedIo)attachment).isEnabledViaRedstone(this.pipe) || currentTick - this.lastOperationTick[side.get3DDataValue()] < (long)itemAttachedIo.getItemOperationTickDelay()) continue;
            this.lastOperationTick[side.get3DDataValue()] = currentTick;
            if (itemAttachedIo.getType() == IoAttachmentType.EXTRACTOR) {
                this.tickExtractor(side, itemAttachedIo);
                continue;
            }
            if (itemAttachedIo.getType() != IoAttachmentType.ATTRACTOR) continue;
            this.tickAttractor(side, itemAttachedIo);
        }
    }

    private void tickExtractor(Direction side, ItemAttachedIo extractor) {
        if (extractor.isStuffed()) {
            MaxParticipant maxParticipant = new MaxParticipant();
            if (extractor.moveStuffedToStorage(this.buildExtractorNetworkInjectStorage(side, extractor, maxParticipant), extractor.getMaxItemsExtracted()) > 0) {
                extractor.incrementRoundRobin(maxParticipant.getMax());
                this.pipe.setChanged();
                if (!extractor.isStuffed()) {
                    this.pipe.sync();
                }
            }
        } else {
            IItemHandler adjStorage = this.getAdjacentStorage(side, false);
            if (adjStorage == null) {
                return;
            }
            MaxParticipant maxParticipant = new MaxParticipant();
            if (this.move(adjStorage, this.buildExtractorNetworkInjectStorage(side, extractor, maxParticipant), extractor::matchesItemFilter, extractor.getMaxItemsExtracted()) > 0) {
                extractor.incrementRoundRobin(maxParticipant.getMax());
            }
        }
    }

    public void tickAttractor(Direction side, ItemAttachedIo attractor) {
        if (attractor.isStuffed()) {
            IItemHandler adjStorage = this.getAdjacentStorage(side, false);
            if (adjStorage == null) {
                return;
            }
            if (attractor.moveStuffedToStorage(adjStorage, attractor.getMaxItemsExtracted()) > 0) {
                this.pipe.setChanged();
                if (!attractor.isStuffed()) {
                    this.pipe.sync();
                }
            }
        } else {
            int maxTransfer;
            SimulatedInsertionTarget insertTarget = SimulatedInsertionTargets.getTarget(this.pipe.getLevel(), this.pipe.getBlockPos().relative(side), side.getOpposite());
            if (!insertTarget.hasStorage()) {
                return;
            }
            NetworkNode<ItemHost, ItemCache> thisNode = this.findNode();
            ItemCache cache = (ItemCache)thisNode.getNetworkCache();
            ItemPathCache pathCache = cache.pathCache;
            Iterable<ItemPath> paths = this.rearrangePaths(pathCache.getPaths(thisNode, side.getOpposite()), attractor);
            int toTransfer = maxTransfer = attractor.getMaxItemsExtracted();
            int nextPathIndex = 0;
            for (ItemPath path : paths) {
                Predicate<ItemVariant> endpointFilter;
                InsertionOnlyItemHandler insertStorage;
                IItemHandler extractTarget;
                ItemAttachedIo io;
                ++nextPathIndex;
                AttachedAttachment attachedAttachment = path.getEndAttachment(cache.level);
                if (attachedAttachment instanceof ItemAttachedIo && (io = (ItemAttachedIo)attachedAttachment).getType() == IoAttachmentType.ATTRACTOR || (extractTarget = (IItemHandler)this.pipe.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, path.targetPos, (Object)path.getTargetBlockSide())) == null || (toTransfer -= this.move(extractTarget, insertStorage = new InsertionOnlyItemHandler((variant, maxAmount, simulate) -> insertTarget.insert(variant, maxAmount, simulate, (v, a) -> {
                    ItemPath reversedPath = path.reversed();
                    TravelingItem travelingItem = reversedPath.makeTravelingItem(v, a, attractor.getItemSpeedupFactor());
                    reversedPath.getStartingPoint(cache.level).getHost().addTravelingItem(travelingItem);
                })), arg_0 -> ItemHost.lambda$tickAttractor$4(attractor, endpointFilter = path.getEndFilter(cache.level), arg_0), toTransfer)) != 0) continue;
                break;
            }
            if (toTransfer < maxTransfer) {
                attractor.incrementRoundRobin(nextPathIndex);
            }
        }
    }

    private int move(IItemHandler from, IItemHandler to, Predicate<ItemVariant> predicate, int maxAmount) {
        int moved = 0;
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemVariant variant;
            ItemStack extracted = from.extractItem(i, maxAmount - moved, true);
            if (extracted.isEmpty() || !predicate.test(variant = ItemVariant.of(extracted))) continue;
            ItemStack overflow = ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)extracted, (boolean)true);
            int likelyToFit = extracted.getCount() - overflow.getCount();
            if (likelyToFit <= 0) continue;
            extracted = from.extractItem(i, likelyToFit, false);
            overflow = ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)extracted, (boolean)false);
            moved += extracted.getCount() - overflow.getCount();
        }
        return moved;
    }

    public void tickMovingItems() {
        TravelingItem travelingItem;
        if (this.travelingItems.isEmpty()) {
            return;
        }
        long curTick = this.getLevel().getGameTime();
        ArrayList<TravelingItem> movedOut = new ArrayList<TravelingItem>();
        Iterator<TravelingItem> iterator = this.travelingItems.iterator();
        while (iterator.hasNext()) {
            travelingItem = iterator.next();
            if (travelingItem.lastTick == curTick) continue;
            travelingItem.lastTick = curTick;
            int currentIndex = (int)travelingItem.traveledDistance;
            travelingItem.traveledDistance += travelingItem.getSpeed();
            int newIndex = (int)travelingItem.traveledDistance;
            if (newIndex == currentIndex) continue;
            movedOut.add(travelingItem);
            iterator.remove();
        }
        Iterator iterator2 = movedOut.iterator();
        while (iterator2.hasNext()) {
            int newIndex = (int)travelingItem.traveledDistance;
            travelingItem = (TravelingItem)iterator2.next();
            if (newIndex >= travelingItem.getPathLength() - 1) {
                ItemAttachedIo io;
                AttachedAttachment attachedAttachment;
                Direction side = travelingItem.path.path[newIndex];
                boolean checkAttachments = travelingItem.strategy != FailedInsertStrategy.DROP;
                IItemHandler storage = this.getAdjacentStorage(side, checkAttachments);
                if (storage == null) {
                    storage = EmptyItemHandler.INSTANCE;
                }
                int inserted = 0;
                if (!checkAttachments || !((attachedAttachment = this.getAttachment(side)) instanceof ItemAttachedIo) || (io = (ItemAttachedIo)attachedAttachment).matchesItemFilter(travelingItem.variant) && io.isEnabledViaRedstone(this.pipe)) {
                    ItemStack overflow = ItemHandlerHelper.insertItemStacked((IItemHandler)storage, (ItemStack)travelingItem.variant.toStack(travelingItem.amount), (boolean)false);
                    inserted = travelingItem.amount - overflow.getCount();
                }
                this.finishTravel(travelingItem, inserted);
                continue;
            }
            Direction adjPipeDirection = travelingItem.path.path[newIndex];
            ItemHost adjacentItemHost = null;
            NetworkNode ownNode = this.findNode();
            for (NetworkNode.Connection connection : ownNode.getConnections()) {
                if (connection.direction() != adjPipeDirection) continue;
                adjacentItemHost = (ItemHost)connection.target().getHost();
            }
            if (adjacentItemHost != null) {
                adjacentItemHost.travelingItems.add(travelingItem);
                adjacentItemHost.pipe.setChanged();
                adjacentItemHost.pipe.sync(false);
                continue;
            }
            this.finishTravel(travelingItem, 0);
        }
        this.pipe.setChanged();
        this.pipe.sync(false);
    }

    private void finishTravel(TravelingItem item, int inserted) {
        ItemAttachedIo io;
        item.path.getInsertionTarget(this.pipe.getLevel()).stopAwaiting(item.variant, item.amount);
        int leftover = item.amount - inserted;
        AttachedAttachment attachment = this.getAttachment(item.path.path[item.getPathLength() - 1]);
        if (leftover > 0 && attachment instanceof ItemAttachedIo && (io = (ItemAttachedIo)attachment).getType() != IoAttachmentType.FILTER) {
            boolean wasStuffed = io.isStuffed();
            io.getStuffedItems().merge(item.variant, item.amount, Integer::sum);
            this.pipe.setChanged();
            if (wasStuffed != io.isStuffed()) {
                this.pipe.sync();
            }
        } else if (leftover > 0) {
            if (item.strategy == FailedInsertStrategy.SEND_BACK_TO_SOURCE) {
                this.addTravelingItem(new TravelingItem(item.variant, leftover, item.path.reversed(), FailedInsertStrategy.DROP, item.speedMultiplier, (double)(item.getPathLength() - 1) - Math.floor(item.traveledDistance)));
            } else {
                DropHelper.dropStack(this.pipe, item.variant, item.amount - inserted);
            }
        }
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeNbt(tag, registries);
        if (this.travelingItems.size() > 0) {
            ListTag list = new ListTag();
            for (TravelingItem travelingItem : this.travelingItems) {
                list.add((Object)travelingItem.toNbt(registries));
            }
            tag.put("travelingItems", (Tag)list);
        }
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries) {
        super.readNbt(tag, registries);
        ListTag list = tag.getList("travelingItems", 10);
        for (int i = 0; i < list.size(); ++i) {
            TravelingItem item = TravelingItem.fromNbt(list.getCompound(i), registries);
            if (item.variant.isBlank()) continue;
            this.travelingItems.add(item);
        }
    }

    @Override
    public void addSelf() {
        super.addSelf();
        for (TravelingItem travelingItem : this.travelingItems) {
            travelingItem.path.getInsertionTarget(this.pipe.getLevel()).startAwaiting(travelingItem.variant, travelingItem.amount);
        }
    }

    @Override
    public void removeSelf() {
        super.removeSelf();
        for (TravelingItem travelingItem : this.travelingItems) {
            travelingItem.path.getInsertionTarget(this.pipe.getLevel()).stopAwaiting(travelingItem.variant, travelingItem.amount);
        }
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        for (TravelingItem travelingItem : this.travelingItems) {
            travelingItem.path.getInsertionTarget(this.pipe.getLevel()).stopAwaiting(travelingItem.variant, travelingItem.amount);
            DropHelper.dropStack(this.pipe, travelingItem.variant, travelingItem.amount);
        }
        this.travelingItems.clear();
    }

    public void addTravelingItem(TravelingItem travelingItem) {
        this.travelingItems.add(travelingItem);
        this.pipe.setChanged();
    }

    @Override
    protected void doUpdate() {
        this.updateConnections();
    }

    public void gatherCapabilities() {
        int oldConnections = this.inventoryConnections;
        for (int i = 0; i < 6; ++i) {
            Direction dir;
            IItemHandler adjacentCap;
            if ((this.inventoryConnections & 1 << i) <= 0 || (this.pipeConnections & 1 << i) != 0 || (adjacentCap = this.adjacentCaps.getCapability(dir = Direction.from3DDataValue((int)i))) != null) continue;
            this.inventoryConnections ^= 1 << i;
        }
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
            NetworkNode node = this.findNode();
            ((ItemCache)node.getNetworkCache()).pathCache.invalidate();
        }
    }

    public void updateConnections() {
        int oldConnections = this.inventoryConnections;
        this.inventoryConnections = 63 - (this.pipeConnections | this.pipe.connectionBlacklist);
        this.gatherCapabilities();
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeClientNbt(CompoundTag tag, RegistryAccess registries) {
        super.writeClientNbt(tag, registries);
        if (!this.travelingItems.isEmpty()) {
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), registries, ConnectionType.NEOFORGE);
            try {
                buf.writeInt(this.travelingItems.size());
                for (TravelingItem travelingItem : this.travelingItems) {
                    travelingItem.writeClient(buf);
                }
                byte[] bytes = new byte[buf.readableBytes()];
                buf.readBytes(bytes);
                tag.putByteArray("items", bytes);
            }
            finally {
                buf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readClientNbt(CompoundTag tag, RegistryAccess registries) {
        super.readClientNbt(tag, registries);
        this.clientTravelingItems.clear();
        byte[] bytes = tag.getByteArray("items");
        if (bytes.length > 0) {
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])bytes), registries, ConnectionType.NEOFORGE);
            try {
                int count = buf.readInt();
                for (int i = 0; i < count; ++i) {
                    ClientTravelingItem newItem = TravelingItem.readClient(buf);
                    this.clientTravelingItems.add(newItem);
                    ClientTravelingItemSmoothing.onReceiveItem(newItem);
                }
            }
            finally {
                buf.release();
            }
        }
    }

    @Override
    public void clientTick() {
        long curTick = this.getLevel().getGameTime();
        Iterator<ClientTravelingItem> it = this.clientTravelingItems.iterator();
        while (it.hasNext()) {
            NodeHost[] nodeHostArray;
            ClientTravelingItem travelingItem = it.next();
            if (travelingItem.lastTick == curTick) continue;
            travelingItem.lastTick = curTick;
            travelingItem.traveledDistance += travelingItem.speed();
            ClientTravelingItemSmoothing.onTickItem(travelingItem);
            if (!(Mth.frac((double)travelingItem.traveledDistance) < travelingItem.speed())) continue;
            it.remove();
            if (!(travelingItem.traveledDistance < travelingItem.totalPathDistance) || !((nodeHostArray = this.getLevel().getBlockEntity(this.getPos().relative(travelingItem.out))) instanceof PipeBlockEntity)) continue;
            PipeBlockEntity otherPipe = (PipeBlockEntity)nodeHostArray;
            nodeHostArray = otherPipe.getHosts();
            int n = nodeHostArray.length;
            for (int i = 0; i < n; ++i) {
                NodeHost host = nodeHostArray[i];
                if (!(host instanceof ItemHost)) continue;
                ItemHost otherItemHost = (ItemHost)host;
                otherItemHost.clientTravelingItems.add(travelingItem);
                travelingItem.in = travelingItem.out;
            }
        }
    }

    public List<ClientTravelingItem> getClientTravelingItems() {
        return this.clientTravelingItems;
    }

    private static /* synthetic */ boolean lambda$tickAttractor$4(ItemAttachedIo attractor, Predicate endpointFilter, ItemVariant v) {
        return attractor.matchesItemFilter(v) && endpointFilter.test(v);
    }
}

