/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.fluid;

import dev.technici4n.moderndynamics.util.FluidVariant;
import java.util.function.Supplier;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilteringFluidHandler
implements IFluidHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FilteringFluidHandler.class);
    private final Supplier<IFluidHandler> delegate;

    public FilteringFluidHandler(IFluidHandler delegate) {
        this.delegate = () -> delegate;
    }

    public FilteringFluidHandler(Supplier<IFluidHandler> delegate) {
        this.delegate = delegate;
    }

    private IFluidHandler getDelegate() {
        return this.delegate.get();
    }

    public int getTanks() {
        return this.getDelegate().getTanks();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getDelegate().getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.getDelegate().getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.getDelegate().isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canInsert(FluidVariant.of(resource))) {
            return 0;
        }
        return this.getDelegate().fill(resource, action);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canExtract(FluidVariant.of(resource))) {
            return FluidStack.EMPTY;
        }
        return this.getDelegate().drain(resource, action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        IFluidHandler delegate = this.getDelegate();
        FluidVariant simulatedDrain = FluidVariant.blank();
        if (action.execute() && !this.canExtract(simulatedDrain = FluidVariant.of(delegate.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE)))) {
            return FluidStack.EMPTY;
        }
        FluidStack drained = this.getDelegate().drain(maxDrain, action);
        FluidVariant drainedVariant = FluidVariant.of(drained);
        if (!simulatedDrain.equals(drainedVariant) || !this.canExtract(drainedVariant)) {
            if (action.execute()) {
                LOG.warn("{} returned fluid {} after returning {} during simulation...", new Object[]{delegate, drained, simulatedDrain});
                delegate.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            }
            return FluidStack.EMPTY;
        }
        return drained;
    }

    protected abstract boolean canInsert(FluidVariant var1);

    protected abstract boolean canExtract(FluidVariant var1);
}

