/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network;

import dev.technici4n.moderndynamics.network.Network;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.NodeHost;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.Nullable;

public class NetworkManager<H extends NodeHost, C extends NetworkCache<H, C>> {
    private static final Map<Class<?>, NetworkManager<?, ?>> MANAGERS = new IdentityHashMap();
    private final Class<C> cacheClass;
    private final NetworkCache.Factory<H, C> cacheFactory;
    private final IdentityHashMap<ServerLevel, Long2ObjectOpenHashMap<NetworkNode<H, C>>> nodes = new IdentityHashMap();
    private final Set<NetworkNode<H, C>> pendingUpdates = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<Network<H, C>> networks = Collections.newSetFromMap(new IdentityHashMap());
    private boolean iteratingOverNetworks = false;

    public static synchronized <H extends NodeHost, C extends NetworkCache<H, C>> NetworkManager<H, C> get(Class<C> cacheClass, NetworkCache.Factory<H, C> factory) {
        Objects.requireNonNull(cacheClass, "Cache class may not be null.");
        Objects.requireNonNull(factory, "Factory may not be null.");
        return MANAGERS.computeIfAbsent(cacheClass, c -> new NetworkManager(cacheClass, factory));
    }

    public static synchronized void onServerStopped() {
        for (NetworkManager<?, ?> manager : MANAGERS.values()) {
            manager.nodes.clear();
            manager.pendingUpdates.clear();
            manager.networks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void onEndTick() {
        for (NetworkManager<?, ?> manager : MANAGERS.values()) {
            manager.updateNetworks();
            manager.iteratingOverNetworks = true;
            try {
                for (Network network : manager.networks) {
                    ((NetworkCache)network.cache).tick();
                }
            }
            finally {
                manager.iteratingOverNetworks = false;
            }
        }
    }

    NetworkManager(Class<C> cacheClass, NetworkCache.Factory<H, C> cacheFactory) {
        this.cacheClass = cacheClass;
        this.cacheFactory = cacheFactory;
    }

    public void addNode(ServerLevel world, BlockPos pos, H host) {
        if (this.iteratingOverNetworks) {
            throw new ConcurrentModificationException("Node at position " + String.valueOf(pos) + " in world " + String.valueOf(world) + " can't be added: networks are being iterated over.");
        }
        Long2ObjectOpenHashMap worldNodes = this.nodes.computeIfAbsent(world, w -> new Long2ObjectOpenHashMap());
        NetworkNode newNode = new NetworkNode(host);
        if (worldNodes.put(pos.asLong(), newNode) != null) {
            throw new IllegalArgumentException("Node at position " + String.valueOf(pos) + " in world " + String.valueOf(world) + " already exists.");
        }
        this.pendingUpdates.add(newNode);
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.relative(direction);
            @Nullable NetworkNode adjacentNode = (NetworkNode)worldNodes.get(adjacentPos.asLong());
            if (adjacentNode == null) continue;
            if (((NodeHost)host).canConnectTo(direction, (NodeHost)adjacentNode.getHost()) && ((NodeHost)adjacentNode.getHost()).canConnectTo(direction.getOpposite(), (NodeHost)host)) {
                if (adjacentNode.network != null) {
                    ((NetworkCache)adjacentNode.network.cache).separate();
                }
                newNode.addConnection(direction, adjacentNode);
                adjacentNode.addConnection(direction.getOpposite(), newNode);
                adjacentNode.updateHostConnections();
                continue;
            }
            ((NodeHost)newNode.getHost()).onConnectionRejectedTo(direction, (NodeHost)adjacentNode.getHost());
            ((NodeHost)adjacentNode.getHost()).onConnectionRejectedTo(direction.getOpposite(), (NodeHost)newNode.getHost());
        }
        newNode.updateHostConnections();
    }

    public void removeNode(ServerLevel world, BlockPos pos, H host) {
        if (this.iteratingOverNetworks) {
            throw new ConcurrentModificationException("Node at position " + String.valueOf(pos) + " in world " + String.valueOf(world) + " can't be removed: networks are being iterated over.");
        }
        Long2ObjectOpenHashMap worldNodes = this.nodes.computeIfAbsent(world, w -> new Long2ObjectOpenHashMap());
        NetworkNode node = (NetworkNode)worldNodes.remove(pos.asLong());
        if (node == null) {
            throw new IllegalArgumentException("Node at position " + String.valueOf(pos) + " in world " + String.valueOf(world) + " can't be removed: it doesn't exist.");
        }
        if (node.getHost() != host) {
            throw new IllegalArgumentException("Node at position " + String.valueOf(pos) + " in world " + String.valueOf(world) + " can't be removed: the hosts don't match.");
        }
        if (node.network != null) {
            ((NetworkCache)node.network.cache).separate();
            this.networks.remove(node.network);
        }
        this.pendingUpdates.remove(node);
        for (NetworkNode.Connection connection : node.getConnections()) {
            NetworkNode target = connection.target();
            target.removeConnection(connection.direction().getOpposite(), node);
            target.updateHostConnections();
            this.pendingUpdates.add(target);
        }
    }

    public void refreshNode(ServerLevel world, BlockPos pos, H host) {
        this.removeNode(world, pos, host);
        this.addNode(world, pos, host);
    }

    @Nullable
    public NetworkNode<H, C> findNode(ServerLevel world, BlockPos pos) {
        this.updateNetworks();
        return (NetworkNode)this.nodes.computeIfAbsent(world, w -> new Long2ObjectOpenHashMap()).get(pos.asLong());
    }

    private void updateNetworks() {
        if (this.pendingUpdates.size() == 0) {
            return;
        }
        ArrayList<NetworkNode<H, C>> pendingUpdatesCopy = new ArrayList<NetworkNode<H, C>>(this.pendingUpdates);
        this.pendingUpdates.clear();
        for (NetworkNode networkNode : pendingUpdatesCopy) {
            if (this.pendingUpdates.contains(networkNode)) continue;
            ArrayList nodes = new ArrayList();
            Network network = new Network(nodes);
            this.assignNetworkDfs(networkNode, network);
            network.cache = this.cacheFactory.build((ServerLevel)((NodeHost)networkNode.getHost()).pipe.getLevel(), network.nodes);
            this.networks.add(network);
        }
        this.pendingUpdates.clear();
    }

    private void assignNetworkDfs(NetworkNode<H, C> u, Network<H, C> network) {
        if (this.pendingUpdates.add(u)) {
            if (u.network != null) {
                this.networks.remove(u.network);
            }
            u.network = network;
            network.nodes.add(u);
            for (NetworkNode.Connection<H, C> connection : u.getConnections()) {
                this.assignNetworkDfs(connection.target(), network);
            }
        }
    }
}

