/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.model;

import dev.technici4n.moderndynamics.attachment.RenderedAttachment;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public record AttachmentModelData(String modelId, Item item) {
    public CompoundTag write(CompoundTag tag) {
        tag.putString("model", this.modelId);
        tag.putString("item", BuiltInRegistries.ITEM.getKey((Object)this.item).toString());
        return tag;
    }

    @Nullable
    public static AttachmentModelData from(CompoundTag tag) {
        String modelId = tag.getString("model");
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getString("item")));
        if (!modelId.isEmpty()) {
            return new AttachmentModelData(modelId, item);
        }
        return null;
    }

    public static AttachmentModelData from(RenderedAttachment rendered, Item item) {
        return new AttachmentModelData(rendered.id, item);
    }
}

