/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.gui.menu;

import com.google.common.util.concurrent.Runnables;
import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.AttachedIo;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.MdId;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.IContainerFactory;

public class AttachmentMenuType<A extends AttachedAttachment, T extends AbstractContainerMenu>
implements IContainerFactory<T> {
    private final AttachmentFactory<A, ? extends AttachmentItem> attachmentFactory;
    private final MenuFactory<A, T> menuFactory;

    public AttachmentMenuType(AttachmentFactory<A, ? extends AttachmentItem> attachmentFactory, MenuFactory<A, T> menuFactory) {
        this.attachmentFactory = attachmentFactory;
        this.menuFactory = menuFactory;
    }

    public T create(int windowId, Inventory inv, RegistryFriendlyByteBuf data) {
        Level world = inv.player.level();
        BlockEntityType bet = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(data.readResourceLocation());
        Direction side = (Direction)data.readEnum(Direction.class);
        BlockPos pos = data.readBlockPos();
        Item item = (Item)BuiltInRegistries.ITEM.byId(data.readVarInt());
        if (!(item instanceof AttachmentItem)) {
            throw new IllegalStateException("Server sent a non-attachment item as menu host: " + String.valueOf(item));
        }
        AttachmentItem attachmentItem = (AttachmentItem)item;
        CompoundTag tag = data.readNbt();
        A attachment = this.attachmentFactory.createAttachment(attachmentItem, tag, Runnables.doNothing(), (HolderLookup.Provider)data.registryAccess());
        return (T)((AbstractContainerMenu)world.getBlockEntity(pos, bet).map(blockEntity -> {
            if (blockEntity instanceof PipeBlockEntity) {
                PipeBlockEntity pipe = (PipeBlockEntity)((Object)blockEntity);
                return this.menuFactory.createMenu(windowId, inv, pipe, side, (AttachedAttachment)attachment);
            }
            return null;
        }).orElse(null));
    }

    public static <A extends AttachedAttachment, T extends AbstractContainerMenu, I extends AttachmentItem> MenuType<T> create(String id, AttachmentFactory<A, I> attachmentFactory, MenuFactory<A, T> menuFactory) {
        AttachmentMenuType<A, T> type = new AttachmentMenuType<A, T>(attachmentFactory, menuFactory);
        MenuType menuType = IMenuTypeExtension.create(type);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)MdId.of(id), (Object)menuType);
        return menuType;
    }

    public static void writeScreenOpeningData(PipeBlockEntity pipe, Direction side, AttachedIo attachment, RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)pipe.getType()));
        buf.writeEnum((Enum)side);
        buf.writeBlockPos(pipe.getBlockPos());
        buf.writeVarInt(BuiltInRegistries.ITEM.getId((Object)attachment.getItem()));
        buf.writeNbt((Tag)attachment.writeConfigTag(new CompoundTag(), (HolderLookup.Provider)buf.registryAccess()));
    }

    public static interface AttachmentFactory<A extends AttachedAttachment, I extends AttachmentItem> {
        public A createAttachment(I var1, CompoundTag var2, Runnable var3, HolderLookup.Provider var4);
    }

    public static interface MenuFactory<A extends AttachedAttachment, T extends AbstractContainerMenu> {
        public T createMenu(int var1, Inventory var2, PipeBlockEntity var3, Direction var4, A var5);
    }
}

